/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobSecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLJobSummary> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoMLJobSummary.getter(AutoMLJobSummary::autoMLJobName)).setter(AutoMLJobSummary.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoMLJobSummary.getter(AutoMLJobSummary::autoMLJobArn)).setter(AutoMLJobSummary.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoMLJobSummary.getter(AutoMLJobSummary::autoMLJobStatusAsString)).setter(AutoMLJobSummary.setter(Builder::autoMLJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoMLJobSummary.getter(AutoMLJobSummary::autoMLJobSecondaryStatusAsString)).setter(AutoMLJobSummary.setter(Builder::autoMLJobSecondaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoMLJobSummary.getter(AutoMLJobSummary::creationTime)).setter(AutoMLJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoMLJobSummary.getter(AutoMLJobSummary::endTime)).setter(AutoMLJobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoMLJobSummary.getter(AutoMLJobSummary::lastModifiedTime)).setter(AutoMLJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoMLJobSummary.getter(AutoMLJobSummary::failureReason)).setter(AutoMLJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, AUTO_ML_JOB_ARN_FIELD, AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoMLJobName;
    private final String autoMLJobArn;
    private final String autoMLJobStatus;
    private final String autoMLJobSecondaryStatus;
    private final Instant creationTime;
    private final Instant endTime;
    private final Instant lastModifiedTime;
    private final String failureReason;

    private AutoMLJobSummary(BuilderImpl builder) {
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    public String autoMLJobName() {
        return this.autoMLJobName;
    }

    public String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(this.autoMLJobStatus);
    }

    public String autoMLJobStatusAsString() {
        return this.autoMLJobStatus;
    }

    public AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(this.autoMLJobSecondaryStatus);
    }

    public String autoMLJobSecondaryStatusAsString() {
        return this.autoMLJobSecondaryStatus;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobSummary)) {
            return false;
        }
        AutoMLJobSummary other = (AutoMLJobSummary)obj;
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.autoMLJobStatusAsString(), other.autoMLJobStatusAsString()) && Objects.equals(this.autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"AutoMLJobSummary").add("AutoMLJobName", (Object)this.autoMLJobName()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("AutoMLJobStatus", (Object)this.autoMLJobStatusAsString()).add("AutoMLJobSecondaryStatus", (Object)this.autoMLJobSecondaryStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "AutoMLJobStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobStatusAsString()));
            }
            case "AutoMLJobSecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobSecondaryStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobSummary, T> g) {
        return obj -> g.apply((AutoMLJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private String autoMLJobArn;
        private String autoMLJobStatus;
        private String autoMLJobSecondaryStatus;
        private Instant creationTime;
        private Instant endTime;
        private Instant lastModifiedTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobSummary model) {
            this.autoMLJobName(model.autoMLJobName);
            this.autoMLJobArn(model.autoMLJobArn);
            this.autoMLJobStatus(model.autoMLJobStatus);
            this.autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final String getAutoMLJobStatus() {
            return this.autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return this.autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public AutoMLJobSummary build() {
            return new AutoMLJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLJobSummary> {
        public Builder autoMLJobName(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder autoMLJobStatus(String var1);

        public Builder autoMLJobStatus(AutoMLJobStatus var1);

        public Builder autoMLJobSecondaryStatus(String var1);

        public Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

