/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ParameterRange;
import software.amazon.awssdk.services.sagemaker.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterSpecification> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterSpecification.getter(HyperParameterSpecification::name)).setter(HyperParameterSpecification.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterSpecification.getter(HyperParameterSpecification::description)).setter(HyperParameterSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterSpecification.getter(HyperParameterSpecification::typeAsString)).setter(HyperParameterSpecification.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ParameterRange> RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterSpecification.getter(HyperParameterSpecification::range)).setter(HyperParameterSpecification.setter(Builder::range)).constructor(ParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build();
    private static final SdkField<Boolean> IS_TUNABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HyperParameterSpecification.getter(HyperParameterSpecification::isTunable)).setter(HyperParameterSpecification.setter(Builder::isTunable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTunable").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HyperParameterSpecification.getter(HyperParameterSpecification::isRequired)).setter(HyperParameterSpecification.setter(Builder::isRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRequired").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterSpecification.getter(HyperParameterSpecification::defaultValue)).setter(HyperParameterSpecification.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, RANGE_FIELD, IS_TUNABLE_FIELD, IS_REQUIRED_FIELD, DEFAULT_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String type;
    private final ParameterRange range;
    private final Boolean isTunable;
    private final Boolean isRequired;
    private final String defaultValue;

    private HyperParameterSpecification(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.range = builder.range;
        this.isTunable = builder.isTunable;
        this.isRequired = builder.isRequired;
        this.defaultValue = builder.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public ParameterRange range() {
        return this.range;
    }

    public Boolean isTunable() {
        return this.isTunable;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTunable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterSpecification)) {
            return false;
        }
        HyperParameterSpecification other = (HyperParameterSpecification)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.range(), other.range()) && Objects.equals(this.isTunable(), other.isTunable()) && Objects.equals(this.isRequired(), other.isRequired()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterSpecification").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("Range", (Object)this.range()).add("IsTunable", (Object)this.isTunable()).add("IsRequired", (Object)this.isRequired()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Range": {
                return Optional.ofNullable(clazz.cast(this.range()));
            }
            case "IsTunable": {
                return Optional.ofNullable(clazz.cast(this.isTunable()));
            }
            case "IsRequired": {
                return Optional.ofNullable(clazz.cast(this.isRequired()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterSpecification, T> g) {
        return obj -> g.apply((HyperParameterSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String type;
        private ParameterRange range;
        private Boolean isTunable;
        private Boolean isRequired;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterSpecification model) {
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.range(model.range);
            this.isTunable(model.isTunable);
            this.isRequired(model.isRequired);
            this.defaultValue(model.defaultValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ParameterRange.Builder getRange() {
            return this.range != null ? this.range.toBuilder() : null;
        }

        @Override
        public final Builder range(ParameterRange range) {
            this.range = range;
            return this;
        }

        public final void setRange(ParameterRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        public final Boolean getIsTunable() {
            return this.isTunable;
        }

        @Override
        public final Builder isTunable(Boolean isTunable) {
            this.isTunable = isTunable;
            return this;
        }

        public final void setIsTunable(Boolean isTunable) {
            this.isTunable = isTunable;
        }

        public final Boolean getIsRequired() {
            return this.isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public HyperParameterSpecification build() {
            return new HyperParameterSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterSpecification> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder range(ParameterRange var1);

        default public Builder range(Consumer<ParameterRange.Builder> range) {
            return this.range((ParameterRange)((ParameterRange.Builder)ParameterRange.builder().applyMutation(range)).build());
        }

        public Builder isTunable(Boolean var1);

        public Builder isRequired(Boolean var1);

        public Builder defaultValue(String var1);
    }
}

