/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CsvContentTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.JsonContentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptureContentTypeHeader
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptureContentTypeHeader> {
    private static final SdkField<List<String>> CSV_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CaptureContentTypeHeader.getter(CaptureContentTypeHeader::csvContentTypes)).setter(CaptureContentTypeHeader.setter(Builder::csvContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> JSON_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CaptureContentTypeHeader.getter(CaptureContentTypeHeader::jsonContentTypes)).setter(CaptureContentTypeHeader.setter(Builder::jsonContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_CONTENT_TYPES_FIELD, JSON_CONTENT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> csvContentTypes;
    private final List<String> jsonContentTypes;

    private CaptureContentTypeHeader(BuilderImpl builder) {
        this.csvContentTypes = builder.csvContentTypes;
        this.jsonContentTypes = builder.jsonContentTypes;
    }

    public boolean hasCsvContentTypes() {
        return this.csvContentTypes != null && !(this.csvContentTypes instanceof SdkAutoConstructList);
    }

    public List<String> csvContentTypes() {
        return this.csvContentTypes;
    }

    public boolean hasJsonContentTypes() {
        return this.jsonContentTypes != null && !(this.jsonContentTypes instanceof SdkAutoConstructList);
    }

    public List<String> jsonContentTypes() {
        return this.jsonContentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csvContentTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonContentTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptureContentTypeHeader)) {
            return false;
        }
        CaptureContentTypeHeader other = (CaptureContentTypeHeader)obj;
        return Objects.equals(this.csvContentTypes(), other.csvContentTypes()) && Objects.equals(this.jsonContentTypes(), other.jsonContentTypes());
    }

    public String toString() {
        return ToString.builder((String)"CaptureContentTypeHeader").add("CsvContentTypes", this.csvContentTypes()).add("JsonContentTypes", this.jsonContentTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CsvContentTypes": {
                return Optional.ofNullable(clazz.cast(this.csvContentTypes()));
            }
            case "JsonContentTypes": {
                return Optional.ofNullable(clazz.cast(this.jsonContentTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptureContentTypeHeader, T> g) {
        return obj -> g.apply((CaptureContentTypeHeader)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> csvContentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> jsonContentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CaptureContentTypeHeader model) {
            this.csvContentTypes(model.csvContentTypes);
            this.jsonContentTypes(model.jsonContentTypes);
        }

        public final Collection<String> getCsvContentTypes() {
            return this.csvContentTypes;
        }

        @Override
        public final Builder csvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvContentTypes(String ... csvContentTypes) {
            this.csvContentTypes(Arrays.asList(csvContentTypes));
            return this;
        }

        public final void setCsvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
        }

        public final Collection<String> getJsonContentTypes() {
            return this.jsonContentTypes;
        }

        @Override
        public final Builder jsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jsonContentTypes(String ... jsonContentTypes) {
            this.jsonContentTypes(Arrays.asList(jsonContentTypes));
            return this;
        }

        public final void setJsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
        }

        public CaptureContentTypeHeader build() {
            return new CaptureContentTypeHeader(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptureContentTypeHeader> {
        public Builder csvContentTypes(Collection<String> var1);

        public Builder csvContentTypes(String ... var1);

        public Builder jsonContentTypes(Collection<String> var1);

        public Builder jsonContentTypes(String ... var1);
    }
}

