/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CognitoMemberDefinition;
import software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberDefinition> {
    private static final SdkField<CognitoMemberDefinition> COGNITO_MEMBER_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MemberDefinition.getter(MemberDefinition::cognitoMemberDefinition)).setter(MemberDefinition.setter(Builder::cognitoMemberDefinition)).constructor(CognitoMemberDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoMemberDefinition").build()}).build();
    private static final SdkField<OidcMemberDefinition> OIDC_MEMBER_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MemberDefinition.getter(MemberDefinition::oidcMemberDefinition)).setter(MemberDefinition.setter(Builder::oidcMemberDefinition)).constructor(OidcMemberDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcMemberDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_MEMBER_DEFINITION_FIELD, OIDC_MEMBER_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CognitoMemberDefinition cognitoMemberDefinition;
    private final OidcMemberDefinition oidcMemberDefinition;

    private MemberDefinition(BuilderImpl builder) {
        this.cognitoMemberDefinition = builder.cognitoMemberDefinition;
        this.oidcMemberDefinition = builder.oidcMemberDefinition;
    }

    public CognitoMemberDefinition cognitoMemberDefinition() {
        return this.cognitoMemberDefinition;
    }

    public OidcMemberDefinition oidcMemberDefinition() {
        return this.oidcMemberDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoMemberDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcMemberDefinition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDefinition)) {
            return false;
        }
        MemberDefinition other = (MemberDefinition)obj;
        return Objects.equals(this.cognitoMemberDefinition(), other.cognitoMemberDefinition()) && Objects.equals(this.oidcMemberDefinition(), other.oidcMemberDefinition());
    }

    public String toString() {
        return ToString.builder((String)"MemberDefinition").add("CognitoMemberDefinition", (Object)this.cognitoMemberDefinition()).add("OidcMemberDefinition", (Object)this.oidcMemberDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CognitoMemberDefinition": {
                return Optional.ofNullable(clazz.cast(this.cognitoMemberDefinition()));
            }
            case "OidcMemberDefinition": {
                return Optional.ofNullable(clazz.cast(this.oidcMemberDefinition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberDefinition, T> g) {
        return obj -> g.apply((MemberDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CognitoMemberDefinition cognitoMemberDefinition;
        private OidcMemberDefinition oidcMemberDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDefinition model) {
            this.cognitoMemberDefinition(model.cognitoMemberDefinition);
            this.oidcMemberDefinition(model.oidcMemberDefinition);
        }

        public final CognitoMemberDefinition.Builder getCognitoMemberDefinition() {
            return this.cognitoMemberDefinition != null ? this.cognitoMemberDefinition.toBuilder() : null;
        }

        @Override
        public final Builder cognitoMemberDefinition(CognitoMemberDefinition cognitoMemberDefinition) {
            this.cognitoMemberDefinition = cognitoMemberDefinition;
            return this;
        }

        public final void setCognitoMemberDefinition(CognitoMemberDefinition.BuilderImpl cognitoMemberDefinition) {
            this.cognitoMemberDefinition = cognitoMemberDefinition != null ? cognitoMemberDefinition.build() : null;
        }

        public final OidcMemberDefinition.Builder getOidcMemberDefinition() {
            return this.oidcMemberDefinition != null ? this.oidcMemberDefinition.toBuilder() : null;
        }

        @Override
        public final Builder oidcMemberDefinition(OidcMemberDefinition oidcMemberDefinition) {
            this.oidcMemberDefinition = oidcMemberDefinition;
            return this;
        }

        public final void setOidcMemberDefinition(OidcMemberDefinition.BuilderImpl oidcMemberDefinition) {
            this.oidcMemberDefinition = oidcMemberDefinition != null ? oidcMemberDefinition.build() : null;
        }

        public MemberDefinition build() {
            return new MemberDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberDefinition> {
        public Builder cognitoMemberDefinition(CognitoMemberDefinition var1);

        default public Builder cognitoMemberDefinition(Consumer<CognitoMemberDefinition.Builder> cognitoMemberDefinition) {
            return this.cognitoMemberDefinition((CognitoMemberDefinition)((CognitoMemberDefinition.Builder)CognitoMemberDefinition.builder().applyMutation(cognitoMemberDefinition)).build());
        }

        public Builder oidcMemberDefinition(OidcMemberDefinition var1);

        default public Builder oidcMemberDefinition(Consumer<OidcMemberDefinition.Builder> oidcMemberDefinition) {
            return this.oidcMemberDefinition((OidcMemberDefinition)((OidcMemberDefinition.Builder)OidcMemberDefinition.builder().applyMutation(oidcMemberDefinition)).build());
        }
    }
}

