/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the trial component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentStatus.Builder, TrialComponentStatus> {
    private static final SdkField<String> PRIMARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrialComponentStatus::primaryStatusAsString)).setter(setter(Builder::primaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrialComponentStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_STATUS_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryStatus;

    private final String message;

    private TrialComponentStatus(BuilderImpl builder) {
        this.primaryStatus = builder.primaryStatus;
        this.message = builder.message;
    }

    /**
     * <p>
     * The status of the trial component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #primaryStatus}
     * will return {@link TrialComponentPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #primaryStatusAsString}.
     * </p>
     * 
     * @return The status of the trial component.
     * @see TrialComponentPrimaryStatus
     */
    public TrialComponentPrimaryStatus primaryStatus() {
        return TrialComponentPrimaryStatus.fromValue(primaryStatus);
    }

    /**
     * <p>
     * The status of the trial component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #primaryStatus}
     * will return {@link TrialComponentPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #primaryStatusAsString}.
     * </p>
     * 
     * @return The status of the trial component.
     * @see TrialComponentPrimaryStatus
     */
    public String primaryStatusAsString() {
        return primaryStatus;
    }

    /**
     * <p>
     * If the component failed, a message describing why.
     * </p>
     * 
     * @return If the component failed, a message describing why.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentStatus)) {
            return false;
        }
        TrialComponentStatus other = (TrialComponentStatus) obj;
        return Objects.equals(primaryStatusAsString(), other.primaryStatusAsString())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrialComponentStatus").add("PrimaryStatus", primaryStatusAsString()).add("Message", message())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryStatus":
            return Optional.ofNullable(clazz.cast(primaryStatusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentStatus, T> g) {
        return obj -> g.apply((TrialComponentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentStatus> {
        /**
         * <p>
         * The status of the trial component.
         * </p>
         * 
         * @param primaryStatus
         *        The status of the trial component.
         * @see TrialComponentPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrialComponentPrimaryStatus
         */
        Builder primaryStatus(String primaryStatus);

        /**
         * <p>
         * The status of the trial component.
         * </p>
         * 
         * @param primaryStatus
         *        The status of the trial component.
         * @see TrialComponentPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrialComponentPrimaryStatus
         */
        Builder primaryStatus(TrialComponentPrimaryStatus primaryStatus);

        /**
         * <p>
         * If the component failed, a message describing why.
         * </p>
         * 
         * @param message
         *        If the component failed, a message describing why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String primaryStatus;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentStatus model) {
            primaryStatus(model.primaryStatus);
            message(model.message);
        }

        public final String getPrimaryStatus() {
            return primaryStatus;
        }

        @Override
        public final Builder primaryStatus(String primaryStatus) {
            this.primaryStatus = primaryStatus;
            return this;
        }

        @Override
        public final Builder primaryStatus(TrialComponentPrimaryStatus primaryStatus) {
            this.primaryStatus(primaryStatus == null ? null : primaryStatus.toString());
            return this;
        }

        public final void setPrimaryStatus(String primaryStatus) {
            this.primaryStatus = primaryStatus;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public TrialComponentStatus build() {
            return new TrialComponentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
