/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A property name returned from a <code>GetSearchSuggestions</code> call that specifies a value in the
 * <code>PropertyNameQuery</code> field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyNameSuggestion implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyNameSuggestion.Builder, PropertyNameSuggestion> {
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PropertyNameSuggestion::propertyName)).setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyName;

    private PropertyNameSuggestion(BuilderImpl builder) {
        this.propertyName = builder.propertyName;
    }

    /**
     * <p>
     * A suggested property name based on what you entered in the search textbox in the Amazon SageMaker console.
     * </p>
     * 
     * @return A suggested property name based on what you entered in the search textbox in the Amazon SageMaker
     *         console.
     */
    public String propertyName() {
        return propertyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyNameSuggestion)) {
            return false;
        }
        PropertyNameSuggestion other = (PropertyNameSuggestion) obj;
        return Objects.equals(propertyName(), other.propertyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PropertyNameSuggestion").add("PropertyName", propertyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyNameSuggestion, T> g) {
        return obj -> g.apply((PropertyNameSuggestion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyNameSuggestion> {
        /**
         * <p>
         * A suggested property name based on what you entered in the search textbox in the Amazon SageMaker console.
         * </p>
         * 
         * @param propertyName
         *        A suggested property name based on what you entered in the search textbox in the Amazon SageMaker
         *        console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);
    }

    static final class BuilderImpl implements Builder {
        private String propertyName;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyNameSuggestion model) {
            propertyName(model.propertyName);
        }

        public final String getPropertyName() {
            return propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public PropertyNameSuggestion build() {
            return new PropertyNameSuggestion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
