/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides counts for human-labeled tasks in the labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelCountersForWorkteam implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelCountersForWorkteam.Builder, LabelCountersForWorkteam> {
    private static final SdkField<Integer> HUMAN_LABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelCountersForWorkteam::humanLabeled)).setter(setter(Builder::humanLabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLabeled").build()).build();

    private static final SdkField<Integer> PENDING_HUMAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelCountersForWorkteam::pendingHuman)).setter(setter(Builder::pendingHuman))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingHuman").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LabelCountersForWorkteam::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LABELED_FIELD,
            PENDING_HUMAN_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer humanLabeled;

    private final Integer pendingHuman;

    private final Integer total;

    private LabelCountersForWorkteam(BuilderImpl builder) {
        this.humanLabeled = builder.humanLabeled;
        this.pendingHuman = builder.pendingHuman;
        this.total = builder.total;
    }

    /**
     * <p>
     * The total number of data objects labeled by a human worker.
     * </p>
     * 
     * @return The total number of data objects labeled by a human worker.
     */
    public Integer humanLabeled() {
        return humanLabeled;
    }

    /**
     * <p>
     * The total number of data objects that need to be labeled by a human worker.
     * </p>
     * 
     * @return The total number of data objects that need to be labeled by a human worker.
     */
    public Integer pendingHuman() {
        return pendingHuman;
    }

    /**
     * <p>
     * The total number of tasks in the labeling job.
     * </p>
     * 
     * @return The total number of tasks in the labeling job.
     */
    public Integer total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(pendingHuman());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelCountersForWorkteam)) {
            return false;
        }
        LabelCountersForWorkteam other = (LabelCountersForWorkteam) obj;
        return Objects.equals(humanLabeled(), other.humanLabeled()) && Objects.equals(pendingHuman(), other.pendingHuman())
                && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelCountersForWorkteam").add("HumanLabeled", humanLabeled())
                .add("PendingHuman", pendingHuman()).add("Total", total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLabeled":
            return Optional.ofNullable(clazz.cast(humanLabeled()));
        case "PendingHuman":
            return Optional.ofNullable(clazz.cast(pendingHuman()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelCountersForWorkteam, T> g) {
        return obj -> g.apply((LabelCountersForWorkteam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelCountersForWorkteam> {
        /**
         * <p>
         * The total number of data objects labeled by a human worker.
         * </p>
         * 
         * @param humanLabeled
         *        The total number of data objects labeled by a human worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLabeled(Integer humanLabeled);

        /**
         * <p>
         * The total number of data objects that need to be labeled by a human worker.
         * </p>
         * 
         * @param pendingHuman
         *        The total number of data objects that need to be labeled by a human worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingHuman(Integer pendingHuman);

        /**
         * <p>
         * The total number of tasks in the labeling job.
         * </p>
         * 
         * @param total
         *        The total number of tasks in the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);
    }

    static final class BuilderImpl implements Builder {
        private Integer humanLabeled;

        private Integer pendingHuman;

        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelCountersForWorkteam model) {
            humanLabeled(model.humanLabeled);
            pendingHuman(model.pendingHuman);
            total(model.total);
        }

        public final Integer getHumanLabeled() {
            return humanLabeled;
        }

        @Override
        public final Builder humanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
            return this;
        }

        public final void setHumanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
        }

        public final Integer getPendingHuman() {
            return pendingHuman;
        }

        @Override
        public final Builder pendingHuman(Integer pendingHuman) {
            this.pendingHuman = pendingHuman;
            return this;
        }

        public final void setPendingHuman(Integer pendingHuman) {
            this.pendingHuman = pendingHuman;
        }

        public final Integer getTotal() {
            return total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public LabelCountersForWorkteam build() {
            return new LabelCountersForWorkteam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
