/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrialResponse extends SageMakerResponse implements
        ToCopyableBuilder<DeleteTrialResponse.Builder, DeleteTrialResponse> {
    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteTrialResponse::trialArn)).setter(setter(Builder::trialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_ARN_FIELD));

    private final String trialArn;

    private DeleteTrialResponse(BuilderImpl builder) {
        super(builder);
        this.trialArn = builder.trialArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial that is being deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial that is being deleted.
     */
    public String trialArn() {
        return trialArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrialResponse)) {
            return false;
        }
        DeleteTrialResponse other = (DeleteTrialResponse) obj;
        return Objects.equals(trialArn(), other.trialArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteTrialResponse").add("TrialArn", trialArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialArn":
            return Optional.ofNullable(clazz.cast(trialArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrialResponse, T> g) {
        return obj -> g.apply((DeleteTrialResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrialResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial that is being deleted.
         * </p>
         * 
         * @param trialArn
         *        The Amazon Resource Name (ARN) of the trial that is being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialArn(String trialArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trialArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrialResponse model) {
            super(model);
            trialArn(model.trialArn);
        }

        public final String getTrialArn() {
            return trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        @Override
        public DeleteTrialResponse build() {
            return new DeleteTrialResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
