/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the status of the rule evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DebugRuleEvaluationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DebugRuleEvaluationStatus.Builder, DebugRuleEvaluationStatus> {
    private static final SdkField<String> RULE_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DebugRuleEvaluationStatus::ruleConfigurationName)).setter(setter(Builder::ruleConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfigurationName").build())
            .build();

    private static final SdkField<String> RULE_EVALUATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DebugRuleEvaluationStatus::ruleEvaluationJobArn)).setter(setter(Builder::ruleEvaluationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleEvaluationJobArn").build())
            .build();

    private static final SdkField<String> RULE_EVALUATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DebugRuleEvaluationStatus::ruleEvaluationStatusAsString))
            .setter(setter(Builder::ruleEvaluationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleEvaluationStatus").build())
            .build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DebugRuleEvaluationStatus::statusDetails)).setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DebugRuleEvaluationStatus::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_CONFIGURATION_NAME_FIELD,
            RULE_EVALUATION_JOB_ARN_FIELD, RULE_EVALUATION_STATUS_FIELD, STATUS_DETAILS_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleConfigurationName;

    private final String ruleEvaluationJobArn;

    private final String ruleEvaluationStatus;

    private final String statusDetails;

    private final Instant lastModifiedTime;

    private DebugRuleEvaluationStatus(BuilderImpl builder) {
        this.ruleConfigurationName = builder.ruleConfigurationName;
        this.ruleEvaluationJobArn = builder.ruleEvaluationJobArn;
        this.ruleEvaluationStatus = builder.ruleEvaluationStatus;
        this.statusDetails = builder.statusDetails;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the rule configuration
     * </p>
     * 
     * @return The name of the rule configuration
     */
    public String ruleConfigurationName() {
        return ruleConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule evaluation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule evaluation job.
     */
    public String ruleEvaluationJobArn() {
        return ruleEvaluationJobArn;
    }

    /**
     * <p>
     * Status of the rule evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleEvaluationStatus} will return {@link RuleEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ruleEvaluationStatusAsString}.
     * </p>
     * 
     * @return Status of the rule evaluation.
     * @see RuleEvaluationStatus
     */
    public RuleEvaluationStatus ruleEvaluationStatus() {
        return RuleEvaluationStatus.fromValue(ruleEvaluationStatus);
    }

    /**
     * <p>
     * Status of the rule evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ruleEvaluationStatus} will return {@link RuleEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ruleEvaluationStatusAsString}.
     * </p>
     * 
     * @return Status of the rule evaluation.
     * @see RuleEvaluationStatus
     */
    public String ruleEvaluationStatusAsString() {
        return ruleEvaluationStatus;
    }

    /**
     * <p>
     * Details from the rule evaluation.
     * </p>
     * 
     * @return Details from the rule evaluation.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * Timestamp when the rule evaluation status was last modified.
     * </p>
     * 
     * @return Timestamp when the rule evaluation status was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleEvaluationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleEvaluationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugRuleEvaluationStatus)) {
            return false;
        }
        DebugRuleEvaluationStatus other = (DebugRuleEvaluationStatus) obj;
        return Objects.equals(ruleConfigurationName(), other.ruleConfigurationName())
                && Objects.equals(ruleEvaluationJobArn(), other.ruleEvaluationJobArn())
                && Objects.equals(ruleEvaluationStatusAsString(), other.ruleEvaluationStatusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DebugRuleEvaluationStatus").add("RuleConfigurationName", ruleConfigurationName())
                .add("RuleEvaluationJobArn", ruleEvaluationJobArn()).add("RuleEvaluationStatus", ruleEvaluationStatusAsString())
                .add("StatusDetails", statusDetails()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleConfigurationName":
            return Optional.ofNullable(clazz.cast(ruleConfigurationName()));
        case "RuleEvaluationJobArn":
            return Optional.ofNullable(clazz.cast(ruleEvaluationJobArn()));
        case "RuleEvaluationStatus":
            return Optional.ofNullable(clazz.cast(ruleEvaluationStatusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DebugRuleEvaluationStatus, T> g) {
        return obj -> g.apply((DebugRuleEvaluationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DebugRuleEvaluationStatus> {
        /**
         * <p>
         * The name of the rule configuration
         * </p>
         * 
         * @param ruleConfigurationName
         *        The name of the rule configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfigurationName(String ruleConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule evaluation job.
         * </p>
         * 
         * @param ruleEvaluationJobArn
         *        The Amazon Resource Name (ARN) of the rule evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleEvaluationJobArn(String ruleEvaluationJobArn);

        /**
         * <p>
         * Status of the rule evaluation.
         * </p>
         * 
         * @param ruleEvaluationStatus
         *        Status of the rule evaluation.
         * @see RuleEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleEvaluationStatus
         */
        Builder ruleEvaluationStatus(String ruleEvaluationStatus);

        /**
         * <p>
         * Status of the rule evaluation.
         * </p>
         * 
         * @param ruleEvaluationStatus
         *        Status of the rule evaluation.
         * @see RuleEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleEvaluationStatus
         */
        Builder ruleEvaluationStatus(RuleEvaluationStatus ruleEvaluationStatus);

        /**
         * <p>
         * Details from the rule evaluation.
         * </p>
         * 
         * @param statusDetails
         *        Details from the rule evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * Timestamp when the rule evaluation status was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Timestamp when the rule evaluation status was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String ruleConfigurationName;

        private String ruleEvaluationJobArn;

        private String ruleEvaluationStatus;

        private String statusDetails;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DebugRuleEvaluationStatus model) {
            ruleConfigurationName(model.ruleConfigurationName);
            ruleEvaluationJobArn(model.ruleEvaluationJobArn);
            ruleEvaluationStatus(model.ruleEvaluationStatus);
            statusDetails(model.statusDetails);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getRuleConfigurationName() {
            return ruleConfigurationName;
        }

        @Override
        public final Builder ruleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
            return this;
        }

        public final void setRuleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
        }

        public final String getRuleEvaluationJobArn() {
            return ruleEvaluationJobArn;
        }

        @Override
        public final Builder ruleEvaluationJobArn(String ruleEvaluationJobArn) {
            this.ruleEvaluationJobArn = ruleEvaluationJobArn;
            return this;
        }

        public final void setRuleEvaluationJobArn(String ruleEvaluationJobArn) {
            this.ruleEvaluationJobArn = ruleEvaluationJobArn;
        }

        public final String getRuleEvaluationStatus() {
            return ruleEvaluationStatus;
        }

        @Override
        public final Builder ruleEvaluationStatus(String ruleEvaluationStatus) {
            this.ruleEvaluationStatus = ruleEvaluationStatus;
            return this;
        }

        @Override
        public final Builder ruleEvaluationStatus(RuleEvaluationStatus ruleEvaluationStatus) {
            this.ruleEvaluationStatus(ruleEvaluationStatus == null ? null : ruleEvaluationStatus.toString());
            return this;
        }

        public final void setRuleEvaluationStatus(String ruleEvaluationStatus) {
            this.ruleEvaluationStatus = ruleEvaluationStatus;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public DebugRuleEvaluationStatus build() {
            return new DebugRuleEvaluationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
