/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSpec> {
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceSpec.getter(ResourceSpec::environmentArn)).setter(ResourceSpec.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceSpec.getter(ResourceSpec::instanceTypeAsString)).setter(ResourceSpec.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ARN_FIELD, INSTANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String environmentArn;
    private final String instanceType;

    private ResourceSpec(BuilderImpl builder) {
        this.environmentArn = builder.environmentArn;
        this.instanceType = builder.instanceType;
    }

    public String environmentArn() {
        return this.environmentArn;
    }

    public AppInstanceType instanceType() {
        return AppInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec)obj;
        return Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResourceSpec").add("EnvironmentArn", (Object)this.environmentArn()).add("InstanceType", (Object)this.instanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpec, T> g) {
        return obj -> g.apply((ResourceSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentArn;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpec model) {
            this.environmentArn(model.environmentArn);
            this.instanceType(model.instanceType);
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(AppInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public ResourceSpec build() {
            return new ResourceSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSpec> {
        public Builder environmentArn(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(AppInstanceType var1);
    }
}

