/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentConfig> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExperimentConfig.getter(ExperimentConfig::experimentName)).setter(ExperimentConfig.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExperimentConfig.getter(ExperimentConfig::trialName)).setter(ExperimentConfig.setter(Builder::trialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExperimentConfig.getter(ExperimentConfig::trialComponentDisplayName)).setter(ExperimentConfig.setter(Builder::trialComponentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentDisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD, TRIAL_NAME_FIELD, TRIAL_COMPONENT_DISPLAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String experimentName;
    private final String trialName;
    private final String trialComponentDisplayName;

    private ExperimentConfig(BuilderImpl builder) {
        this.experimentName = builder.experimentName;
        this.trialName = builder.trialName;
        this.trialComponentDisplayName = builder.trialComponentDisplayName;
    }

    public String experimentName() {
        return this.experimentName;
    }

    public String trialName() {
        return this.trialName;
    }

    public String trialComponentDisplayName() {
        return this.trialComponentDisplayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentDisplayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentConfig)) {
            return false;
        }
        ExperimentConfig other = (ExperimentConfig)obj;
        return Objects.equals(this.experimentName(), other.experimentName()) && Objects.equals(this.trialName(), other.trialName()) && Objects.equals(this.trialComponentDisplayName(), other.trialComponentDisplayName());
    }

    public String toString() {
        return ToString.builder((String)"ExperimentConfig").add("ExperimentName", (Object)this.experimentName()).add("TrialName", (Object)this.trialName()).add("TrialComponentDisplayName", (Object)this.trialComponentDisplayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
            case "TrialName": {
                return Optional.ofNullable(clazz.cast(this.trialName()));
            }
            case "TrialComponentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentDisplayName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentConfig, T> g) {
        return obj -> g.apply((ExperimentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String experimentName;
        private String trialName;
        private String trialComponentDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentConfig model) {
            this.experimentName(model.experimentName);
            this.trialName(model.trialName);
            this.trialComponentDisplayName(model.trialComponentDisplayName);
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        public final String getTrialName() {
            return this.trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        public final String getTrialComponentDisplayName() {
            return this.trialComponentDisplayName;
        }

        @Override
        public final Builder trialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
            return this;
        }

        public final void setTrialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
        }

        public ExperimentConfig build() {
            return new ExperimentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentConfig> {
        public Builder experimentName(String var1);

        public Builder trialName(String var1);

        public Builder trialComponentDisplayName(String var1);
    }
}

