/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLChannel;
import software.amazon.awssdk.services.sagemaker.model.AutoMLInputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.AutoMLOutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ProblemType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutoMlJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateAutoMlJobRequest> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::autoMLJobName)).setter(CreateAutoMlJobRequest.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<List<AutoMLChannel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::inputDataConfig)).setter(CreateAutoMlJobRequest.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::outputDataConfig)).setter(CreateAutoMlJobRequest.setter(Builder::outputDataConfig)).constructor(AutoMLOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::problemTypeAsString)).setter(CreateAutoMlJobRequest.setter(Builder::problemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()}).build();
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::autoMLJobObjective)).setter(CreateAutoMlJobRequest.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<AutoMLJobConfig> AUTO_ML_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::autoMLJobConfig)).setter(CreateAutoMlJobRequest.setter(Builder::autoMLJobConfig)).constructor(AutoMLJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::roleArn)).setter(CreateAutoMlJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Boolean> GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::generateCandidateDefinitionsOnly)).setter(CreateAutoMlJobRequest.setter(Builder::generateCandidateDefinitionsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateCandidateDefinitionsOnly").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAutoMlJobRequest.getter(CreateAutoMlJobRequest::tags)).setter(CreateAutoMlJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, PROBLEM_TYPE_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD, AUTO_ML_JOB_CONFIG_FIELD, ROLE_ARN_FIELD, GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD, TAGS_FIELD));
    private final String autoMLJobName;
    private final List<AutoMLChannel> inputDataConfig;
    private final AutoMLOutputDataConfig outputDataConfig;
    private final String problemType;
    private final AutoMLJobObjective autoMLJobObjective;
    private final AutoMLJobConfig autoMLJobConfig;
    private final String roleArn;
    private final Boolean generateCandidateDefinitionsOnly;
    private final List<Tag> tags;

    private CreateAutoMlJobRequest(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.problemType = builder.problemType;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.autoMLJobConfig = builder.autoMLJobConfig;
        this.roleArn = builder.roleArn;
        this.generateCandidateDefinitionsOnly = builder.generateCandidateDefinitionsOnly;
        this.tags = builder.tags;
    }

    public String autoMLJobName() {
        return this.autoMLJobName;
    }

    public boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public List<AutoMLChannel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public AutoMLOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ProblemType problemType() {
        return ProblemType.fromValue(this.problemType);
    }

    public String problemTypeAsString() {
        return this.problemType;
    }

    public AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public AutoMLJobConfig autoMLJobConfig() {
        return this.autoMLJobConfig;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Boolean generateCandidateDefinitionsOnly() {
        return this.generateCandidateDefinitionsOnly;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateCandidateDefinitionsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoMlJobRequest)) {
            return false;
        }
        CreateAutoMlJobRequest other = (CreateAutoMlJobRequest)((Object)obj);
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.problemTypeAsString(), other.problemTypeAsString()) && Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.autoMLJobConfig(), other.autoMLJobConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.generateCandidateDefinitionsOnly(), other.generateCandidateDefinitionsOnly()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateAutoMlJobRequest").add("AutoMLJobName", (Object)this.autoMLJobName()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ProblemType", (Object)this.problemTypeAsString()).add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("AutoMLJobConfig", (Object)this.autoMLJobConfig()).add("RoleArn", (Object)this.roleArn()).add("GenerateCandidateDefinitionsOnly", (Object)this.generateCandidateDefinitionsOnly()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ProblemType": {
                return Optional.ofNullable(clazz.cast(this.problemTypeAsString()));
            }
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "AutoMLJobConfig": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "GenerateCandidateDefinitionsOnly": {
                return Optional.ofNullable(clazz.cast(this.generateCandidateDefinitionsOnly()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoMlJobRequest, T> g) {
        return obj -> g.apply((CreateAutoMlJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private List<AutoMLChannel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private AutoMLOutputDataConfig outputDataConfig;
        private String problemType;
        private AutoMLJobObjective autoMLJobObjective;
        private AutoMLJobConfig autoMLJobConfig;
        private String roleArn;
        private Boolean generateCandidateDefinitionsOnly;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoMlJobRequest model) {
            super(model);
            this.autoMLJobName(model.autoMLJobName);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.problemType(model.problemType);
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.autoMLJobConfig(model.autoMLJobConfig);
            this.roleArn(model.roleArn);
            this.generateCandidateDefinitionsOnly(model.generateCandidateDefinitionsOnly);
            this.tags(model.tags);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final Collection<AutoMLChannel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(AutoMLChannel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(AutoMLChannel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<AutoMLChannel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (AutoMLChannel)((AutoMLChannel.Builder)AutoMLChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<AutoMLChannel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getProblemTypeAsString() {
            return this.problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        public final AutoMLJobConfig.Builder getAutoMLJobConfig() {
            return this.autoMLJobConfig != null ? this.autoMLJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig;
            return this;
        }

        public final void setAutoMLJobConfig(AutoMLJobConfig.BuilderImpl autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig != null ? autoMLJobConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Boolean getGenerateCandidateDefinitionsOnly() {
            return this.generateCandidateDefinitionsOnly;
        }

        @Override
        public final Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
            return this;
        }

        public final void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoMlJobRequest build() {
            return new CreateAutoMlJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutoMlJobRequest> {
        public Builder autoMLJobName(String var1);

        public Builder inputDataConfig(Collection<AutoMLChannel> var1);

        public Builder inputDataConfig(AutoMLChannel ... var1);

        public Builder inputDataConfig(Consumer<AutoMLChannel.Builder> ... var1);

        public Builder outputDataConfig(AutoMLOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AutoMLOutputDataConfig)((AutoMLOutputDataConfig.Builder)AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder problemType(String var1);

        public Builder problemType(ProblemType var1);

        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder autoMLJobConfig(AutoMLJobConfig var1);

        default public Builder autoMLJobConfig(Consumer<AutoMLJobConfig.Builder> autoMLJobConfig) {
            return this.autoMLJobConfig((AutoMLJobConfig)((AutoMLJobConfig.Builder)AutoMLJobConfig.builder().applyMutation(autoMLJobConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder generateCandidateDefinitionsOnly(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

