/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sharing settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharingSettings implements SdkPojo, Serializable, ToCopyableBuilder<SharingSettings.Builder, SharingSettings> {
    private static final SdkField<String> NOTEBOOK_OUTPUT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SharingSettings::notebookOutputOptionAsString)).setter(setter(Builder::notebookOutputOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookOutputOption").build())
            .build();

    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SharingSettings::s3OutputPath)).setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final SdkField<String> S3_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SharingSettings::s3KmsKeyId)).setter(setter(Builder::s3KmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_OUTPUT_OPTION_FIELD,
            S3_OUTPUT_PATH_FIELD, S3_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String notebookOutputOption;

    private final String s3OutputPath;

    private final String s3KmsKeyId;

    private SharingSettings(BuilderImpl builder) {
        this.notebookOutputOption = builder.notebookOutputOption;
        this.s3OutputPath = builder.s3OutputPath;
        this.s3KmsKeyId = builder.s3KmsKeyId;
    }

    /**
     * <p>
     * The notebook output option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookOutputOption} will return {@link NotebookOutputOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookOutputOptionAsString}.
     * </p>
     * 
     * @return The notebook output option.
     * @see NotebookOutputOption
     */
    public NotebookOutputOption notebookOutputOption() {
        return NotebookOutputOption.fromValue(notebookOutputOption);
    }

    /**
     * <p>
     * The notebook output option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookOutputOption} will return {@link NotebookOutputOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookOutputOptionAsString}.
     * </p>
     * 
     * @return The notebook output option.
     * @see NotebookOutputOption
     */
    public String notebookOutputOptionAsString() {
        return notebookOutputOption;
    }

    /**
     * <p>
     * The Amazon S3 output path.
     * </p>
     * 
     * @return The Amazon S3 output path.
     */
    public String s3OutputPath() {
        return s3OutputPath;
    }

    /**
     * <p>
     * The AWS Key Management Service encryption key ID.
     * </p>
     * 
     * @return The AWS Key Management Service encryption key ID.
     */
    public String s3KmsKeyId() {
        return s3KmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notebookOutputOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3KmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharingSettings)) {
            return false;
        }
        SharingSettings other = (SharingSettings) obj;
        return Objects.equals(notebookOutputOptionAsString(), other.notebookOutputOptionAsString())
                && Objects.equals(s3OutputPath(), other.s3OutputPath()) && Objects.equals(s3KmsKeyId(), other.s3KmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SharingSettings").add("NotebookOutputOption", notebookOutputOptionAsString())
                .add("S3OutputPath", s3OutputPath()).add("S3KmsKeyId", s3KmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookOutputOption":
            return Optional.ofNullable(clazz.cast(notebookOutputOptionAsString()));
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        case "S3KmsKeyId":
            return Optional.ofNullable(clazz.cast(s3KmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharingSettings, T> g) {
        return obj -> g.apply((SharingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharingSettings> {
        /**
         * <p>
         * The notebook output option.
         * </p>
         * 
         * @param notebookOutputOption
         *        The notebook output option.
         * @see NotebookOutputOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookOutputOption
         */
        Builder notebookOutputOption(String notebookOutputOption);

        /**
         * <p>
         * The notebook output option.
         * </p>
         * 
         * @param notebookOutputOption
         *        The notebook output option.
         * @see NotebookOutputOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookOutputOption
         */
        Builder notebookOutputOption(NotebookOutputOption notebookOutputOption);

        /**
         * <p>
         * The Amazon S3 output path.
         * </p>
         * 
         * @param s3OutputPath
         *        The Amazon S3 output path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);

        /**
         * <p>
         * The AWS Key Management Service encryption key ID.
         * </p>
         * 
         * @param s3KmsKeyId
         *        The AWS Key Management Service encryption key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KmsKeyId(String s3KmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String notebookOutputOption;

        private String s3OutputPath;

        private String s3KmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SharingSettings model) {
            notebookOutputOption(model.notebookOutputOption);
            s3OutputPath(model.s3OutputPath);
            s3KmsKeyId(model.s3KmsKeyId);
        }

        public final String getNotebookOutputOptionAsString() {
            return notebookOutputOption;
        }

        @Override
        public final Builder notebookOutputOption(String notebookOutputOption) {
            this.notebookOutputOption = notebookOutputOption;
            return this;
        }

        @Override
        public final Builder notebookOutputOption(NotebookOutputOption notebookOutputOption) {
            this.notebookOutputOption(notebookOutputOption == null ? null : notebookOutputOption.toString());
            return this;
        }

        public final void setNotebookOutputOption(String notebookOutputOption) {
            this.notebookOutputOption = notebookOutputOption;
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public final String getS3KmsKeyId() {
            return s3KmsKeyId;
        }

        @Override
        public final Builder s3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
            return this;
        }

        public final void setS3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
        }

        @Override
        public SharingSettings build() {
            return new SharingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
