/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrainingJob;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponentSourceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponentSourceDetail> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::sourceArn)).setter(TrialComponentSourceDetail.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponentSourceDetail.getter(TrialComponentSourceDetail::trainingJob)).setter(TrialComponentSourceDetail.setter(Builder::trainingJob)).constructor(TrainingJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, TRAINING_JOB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final TrainingJob trainingJob;

    private TrialComponentSourceDetail(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.trainingJob = builder.trainingJob;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public TrainingJob trainingJob() {
        return this.trainingJob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJob());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSourceDetail)) {
            return false;
        }
        TrialComponentSourceDetail other = (TrialComponentSourceDetail)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.trainingJob(), other.trainingJob());
    }

    public String toString() {
        return ToString.builder((String)"TrialComponentSourceDetail").add("SourceArn", (Object)this.sourceArn()).add("TrainingJob", (Object)this.trainingJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "TrainingJob": {
                return Optional.ofNullable(clazz.cast(this.trainingJob()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSourceDetail, T> g) {
        return obj -> g.apply((TrialComponentSourceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private TrainingJob trainingJob;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSourceDetail model) {
            this.sourceArn(model.sourceArn);
            this.trainingJob(model.trainingJob);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final TrainingJob.Builder getTrainingJob() {
            return this.trainingJob != null ? this.trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        public TrialComponentSourceDetail build() {
            return new TrialComponentSourceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponentSourceDetail> {
        public Builder sourceArn(String var1);

        public Builder trainingJob(TrainingJob var1);

        default public Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return this.trainingJob((TrainingJob)((TrainingJob.Builder)TrainingJob.builder().applyMutation(trainingJob)).build());
        }
    }
}

