/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlgorithmsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAlgorithmsResponse> {
    private static final SdkField<List<AlgorithmSummary>> ALGORITHM_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAlgorithmsResponse.getter(ListAlgorithmsResponse::algorithmSummaryList)).setter(ListAlgorithmsResponse.setter(Builder::algorithmSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlgorithmSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAlgorithmsResponse.getter(ListAlgorithmsResponse::nextToken)).setter(ListAlgorithmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AlgorithmSummary> algorithmSummaryList;
    private final String nextToken;

    private ListAlgorithmsResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmSummaryList = builder.algorithmSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<AlgorithmSummary> algorithmSummaryList() {
        return this.algorithmSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlgorithmsResponse)) {
            return false;
        }
        ListAlgorithmsResponse other = (ListAlgorithmsResponse)((Object)obj);
        return Objects.equals(this.algorithmSummaryList(), other.algorithmSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAlgorithmsResponse").add("AlgorithmSummaryList", this.algorithmSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmSummaryList": {
                return Optional.ofNullable(clazz.cast(this.algorithmSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlgorithmsResponse, T> g) {
        return obj -> g.apply((ListAlgorithmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AlgorithmSummary> algorithmSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlgorithmsResponse model) {
            super(model);
            this.algorithmSummaryList(model.algorithmSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AlgorithmSummary.Builder> getAlgorithmSummaryList() {
            return this.algorithmSummaryList != null ? (Collection)this.algorithmSummaryList.stream().map(AlgorithmSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder algorithmSummaryList(Collection<AlgorithmSummary> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copy(algorithmSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(AlgorithmSummary ... algorithmSummaryList) {
            this.algorithmSummaryList(Arrays.asList(algorithmSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder> ... algorithmSummaryList) {
            this.algorithmSummaryList(Stream.of(algorithmSummaryList).map(c -> (AlgorithmSummary)((AlgorithmSummary.Builder)AlgorithmSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlgorithmSummaryList(Collection<AlgorithmSummary.BuilderImpl> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copyFromBuilder(algorithmSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAlgorithmsResponse build() {
            return new ListAlgorithmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlgorithmsResponse> {
        public Builder algorithmSummaryList(Collection<AlgorithmSummary> var1);

        public Builder algorithmSummaryList(AlgorithmSummary ... var1);

        public Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

