/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.DataSource;
import software.amazon.awssdk.services.sagemaker.transform.S3DataSourceUnmarshaller;

public class DataSourceUnmarshaller
implements Unmarshaller<DataSource, JsonUnmarshallerContext> {
    private static final DataSourceUnmarshaller INSTANCE = new DataSourceUnmarshaller();

    public DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataSource.Builder dataSourceBuilder = DataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3DataSource", targetDepth)) {
                    context.nextToken();
                    dataSourceBuilder.s3DataSource(S3DataSourceUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DataSource)dataSourceBuilder.build();
    }

    public static DataSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

