/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;

public final class ListNotebookInstancesPaginator
implements SdkIterable<ListNotebookInstancesResponse> {
    private final SageMakerClient client;
    private final ListNotebookInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListNotebookInstancesPaginator(SageMakerClient client, ListNotebookInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNotebookInstancesResponseFetcher();
    }

    public Iterator<ListNotebookInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListNotebookInstancesResponseFetcher
    implements NextPageFetcher<ListNotebookInstancesResponse> {
        private ListNotebookInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListNotebookInstancesResponse nextPage(ListNotebookInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookInstancesPaginator.this.client.listNotebookInstances(ListNotebookInstancesPaginator.this.firstRequest);
            }
            return ListNotebookInstancesPaginator.this.client.listNotebookInstances((ListNotebookInstancesRequest)((Object)ListNotebookInstancesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

