/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.transform.ContainerDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContainerDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ContainerDefinition> {
    private final String containerHostname;
    private final String image;
    private final String modelDataUrl;
    private final Map<String, String> environment;

    private ContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.modelDataUrl = builder.modelDataUrl;
        this.environment = builder.environment;
    }

    public String containerHostname() {
        return this.containerHostname;
    }

    public String image() {
        return this.image;
    }

    public String modelDataUrl() {
        return this.modelDataUrl;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        return Objects.equals(this.containerHostname(), other.containerHostname()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.modelDataUrl(), other.modelDataUrl()) && Objects.equals(this.environment(), other.environment());
    }

    public String toString() {
        return ToString.builder((String)"ContainerDefinition").add("ContainerHostname", (Object)this.containerHostname()).add("Image", (Object)this.image()).add("ModelDataUrl", (Object)this.modelDataUrl()).add("Environment", this.environment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerHostname": {
                return Optional.of(clazz.cast(this.containerHostname()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "ModelDataUrl": {
                return Optional.of(clazz.cast(this.modelDataUrl()));
            }
            case "Environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerHostname;
        private String image;
        private String modelDataUrl;
        private Map<String, String> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            this.containerHostname(model.containerHostname);
            this.image(model.image);
            this.modelDataUrl(model.modelDataUrl);
            this.environment(model.environment);
        }

        public final String getContainerHostname() {
            return this.containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getModelDataUrl() {
            return this.modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContainerDefinition> {
        public Builder containerHostname(String var1);

        public Builder image(String var1);

        public Builder modelDataUrl(String var1);

        public Builder environment(Map<String, String> var1);
    }
}

