/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceType {
    ML_T2_MEDIUM("ml.t2.medium"),
    ML_T2_LARGE("ml.t2.large"),
    ML_T2_XLARGE("ml.t2.xlarge"),
    ML_T2_2_XLARGE("ml.t2.2xlarge"),
    ML_M4_XLARGE("ml.m4.xlarge"),
    ML_M4_2_XLARGE("ml.m4.2xlarge"),
    ML_M4_4_XLARGE("ml.m4.4xlarge"),
    ML_M4_10_XLARGE("ml.m4.10xlarge"),
    ML_M4_16_XLARGE("ml.m4.16xlarge"),
    ML_P2_XLARGE("ml.p2.xlarge"),
    ML_P2_8_XLARGE("ml.p2.8xlarge"),
    ML_P2_16_XLARGE("ml.p2.16xlarge"),
    ML_P3_2_XLARGE("ml.p3.2xlarge"),
    ML_P3_8_XLARGE("ml.p3.8xlarge"),
    ML_P3_16_XLARGE("ml.p3.16xlarge"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceType> knownValues() {
        return Stream.of(InstanceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

