/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.services.sagemaker.model.DataSource;
import software.amazon.awssdk.services.sagemaker.model.RecordWrapper;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::channelName)).setter(Channel.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Channel.getter(Channel::dataSource)).setter(Channel.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::contentType)).setter(Channel.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::compressionTypeAsString)).setter(Channel.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<String> RECORD_WRAPPER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Channel.getter(Channel::recordWrapperTypeAsString)).setter(Channel.setter(Builder::recordWrapperType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordWrapperType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, DATA_SOURCE_FIELD, CONTENT_TYPE_FIELD, COMPRESSION_TYPE_FIELD, RECORD_WRAPPER_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelName;
    private final DataSource dataSource;
    private final String contentType;
    private final String compressionType;
    private final String recordWrapperType;

    private Channel(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.dataSource = builder.dataSource;
        this.contentType = builder.contentType;
        this.compressionType = builder.compressionType;
        this.recordWrapperType = builder.recordWrapperType;
    }

    public String channelName() {
        return this.channelName;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public String contentType() {
        return this.contentType;
    }

    public CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public String compressionTypeAsString() {
        return this.compressionType;
    }

    public RecordWrapper recordWrapperType() {
        return RecordWrapper.fromValue(this.recordWrapperType);
    }

    public String recordWrapperTypeAsString() {
        return this.recordWrapperType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordWrapperTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.recordWrapperTypeAsString(), other.recordWrapperTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Channel").add("ChannelName", (Object)this.channelName()).add("DataSource", (Object)this.dataSource()).add("ContentType", (Object)this.contentType()).add("CompressionType", (Object)this.compressionTypeAsString()).add("RecordWrapperType", (Object)this.recordWrapperTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "RecordWrapperType": {
                return Optional.ofNullable(clazz.cast(this.recordWrapperTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelName;
        private DataSource dataSource;
        private String contentType;
        private String compressionType;
        private String recordWrapperType;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.channelName(model.channelName);
            this.dataSource(model.dataSource);
            this.contentType(model.contentType);
            this.compressionType(model.compressionType);
            this.recordWrapperType(model.recordWrapperType);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public final String getRecordWrapperType() {
            return this.recordWrapperType;
        }

        @Override
        public final Builder recordWrapperType(String recordWrapperType) {
            this.recordWrapperType = recordWrapperType;
            return this;
        }

        @Override
        public final Builder recordWrapperType(RecordWrapper recordWrapperType) {
            this.recordWrapperType(recordWrapperType.toString());
            return this;
        }

        public final void setRecordWrapperType(String recordWrapperType) {
            this.recordWrapperType = recordWrapperType;
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder channelName(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder contentType(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder recordWrapperType(String var1);

        public Builder recordWrapperType(RecordWrapper var1);
    }
}

