/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransformResourcesMarshaller {
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMEKMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeKmsKeyId").isBinary(false).build();
    private static final TransformResourcesMarshaller INSTANCE = new TransformResourcesMarshaller();

    private TransformResourcesMarshaller() {
    }

    public static TransformResourcesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransformResources transformResources, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transformResources, (String)"transformResources");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transformResources.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)transformResources.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)transformResources.volumeKmsKeyId(), VOLUMEKMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

