/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformJobSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransformJobSummaryMarshaller {
    private static final MarshallingInfo<String> TRANSFORMJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformJobName").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSFORMJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformJobArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> TRANSFORMENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformEndTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSFORMJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformJobStatus").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").isBinary(false).build();
    private static final TransformJobSummaryMarshaller INSTANCE = new TransformJobSummaryMarshaller();

    private TransformJobSummaryMarshaller() {
    }

    public static TransformJobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransformJobSummary transformJobSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transformJobSummary, (String)"transformJobSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transformJobSummary.transformJobName(), TRANSFORMJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.transformJobArn(), TRANSFORMJOBARN_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.transformEndTime(), TRANSFORMENDTIME_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.lastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.transformJobStatusAsString(), TRANSFORMJOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)transformJobSummary.failureReason(), FAILUREREASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

