/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricDefinitionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> REGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Regex").isBinary(false).build();
    private static final MetricDefinitionMarshaller INSTANCE = new MetricDefinitionMarshaller();

    private MetricDefinitionMarshaller() {
    }

    public static MetricDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricDefinition metricDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricDefinition, (String)"metricDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricDefinition.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)metricDefinition.regex(), REGEX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

