/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HyperParameterTrainingJobDefinitionMarshaller {
    private static final MarshallingInfo<Map> STATICHYPERPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StaticHyperParameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ALGORITHMSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlgorithmSpecification").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STOPPINGCONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoppingCondition").isBinary(false).build();
    private static final HyperParameterTrainingJobDefinitionMarshaller INSTANCE = new HyperParameterTrainingJobDefinitionMarshaller();

    private HyperParameterTrainingJobDefinitionMarshaller() {
    }

    public static HyperParameterTrainingJobDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HyperParameterTrainingJobDefinition hyperParameterTrainingJobDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hyperParameterTrainingJobDefinition, (String)"hyperParameterTrainingJobDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(hyperParameterTrainingJobDefinition.staticHyperParameters(), STATICHYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.algorithmSpecification(), ALGORITHMSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(hyperParameterTrainingJobDefinition.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.resourceConfig(), RESOURCECONFIG_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterTrainingJobDefinition.stoppingCondition(), STOPPINGCONDITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

