/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HyperParameterAlgorithmSpecificationMarshaller {
    private static final MarshallingInfo<String> TRAININGIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImage").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingInputMode").isBinary(false).build();
    private static final MarshallingInfo<List> METRICDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricDefinitions").isBinary(false).build();
    private static final HyperParameterAlgorithmSpecificationMarshaller INSTANCE = new HyperParameterAlgorithmSpecificationMarshaller();

    private HyperParameterAlgorithmSpecificationMarshaller() {
    }

    public static HyperParameterAlgorithmSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HyperParameterAlgorithmSpecification hyperParameterAlgorithmSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hyperParameterAlgorithmSpecification, (String)"hyperParameterAlgorithmSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hyperParameterAlgorithmSpecification.trainingImage(), TRAININGIMAGE_BINDING);
            protocolMarshaller.marshall((Object)hyperParameterAlgorithmSpecification.trainingInputModeAsString(), TRAININGINPUTMODE_BINDING);
            protocolMarshaller.marshall(hyperParameterAlgorithmSpecification.metricDefinitions(), METRICDEFINITIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

