/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.DeployedImage;

public class DeployedImageUnmarshaller
implements Unmarshaller<DeployedImage, JsonUnmarshallerContext> {
    private static final DeployedImageUnmarshaller INSTANCE = new DeployedImageUnmarshaller();

    public DeployedImage unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeployedImage.Builder deployedImageBuilder = DeployedImage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SpecifiedImage", targetDepth)) {
                    context.nextToken();
                    deployedImageBuilder.specifiedImage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResolvedImage", targetDepth)) {
                    context.nextToken();
                    deployedImageBuilder.resolvedImage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResolutionTime", targetDepth)) {
                    context.nextToken();
                    deployedImageBuilder.resolutionTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DeployedImage)deployedImageBuilder.build();
    }

    public static DeployedImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

