/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStatus;
import software.amazon.awssdk.services.sagemaker.transform.TransformJobSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformJobSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TransformJobSummary> {
    private final String transformJobName;
    private final String transformJobArn;
    private final Instant creationTime;
    private final Instant transformEndTime;
    private final Instant lastModifiedTime;
    private final String transformJobStatus;
    private final String failureReason;

    private TransformJobSummary(BuilderImpl builder) {
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.creationTime = builder.creationTime;
        this.transformEndTime = builder.transformEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
    }

    public String transformJobName() {
        return this.transformJobName;
    }

    public String transformJobArn() {
        return this.transformJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant transformEndTime() {
        return this.transformEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(this.transformJobStatus);
    }

    public String transformJobStatusAsString() {
        return this.transformJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformJobSummary)) {
            return false;
        }
        TransformJobSummary other = (TransformJobSummary)obj;
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.transformJobArn(), other.transformJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.transformEndTime(), other.transformEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.transformJobStatusAsString(), other.transformJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"TransformJobSummary").add("TransformJobName", (Object)this.transformJobName()).add("TransformJobArn", (Object)this.transformJobArn()).add("CreationTime", (Object)this.creationTime()).add("TransformEndTime", (Object)this.transformEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TransformJobStatus", (Object)this.transformJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "TransformJobArn": {
                return Optional.ofNullable(clazz.cast(this.transformJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TransformEndTime": {
                return Optional.ofNullable(clazz.cast(this.transformEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TransformJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transformJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformJobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformJobName;
        private String transformJobArn;
        private Instant creationTime;
        private Instant transformEndTime;
        private Instant lastModifiedTime;
        private String transformJobStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformJobSummary model) {
            this.transformJobName(model.transformJobName);
            this.transformJobArn(model.transformJobArn);
            this.creationTime(model.creationTime);
            this.transformEndTime(model.transformEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.transformJobStatus(model.transformJobStatus);
            this.failureReason(model.failureReason);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getTransformJobArn() {
            return this.transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTransformEndTime() {
            return this.transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getTransformJobStatus() {
            return this.transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus.toString());
            return this;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public TransformJobSummary build() {
            return new TransformJobSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransformJobSummary> {
        public Builder transformJobName(String var1);

        public Builder transformJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder transformEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder transformJobStatus(String var1);

        public Builder transformJobStatus(TransformJobStatus var1);

        public Builder failureReason(String var1);
    }
}

