/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeployedImage;
import software.amazon.awssdk.services.sagemaker.model.DeployedImagesCopier;
import software.amazon.awssdk.services.sagemaker.transform.ProductionVariantSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ProductionVariantSummary> {
    private final String variantName;
    private final List<DeployedImage> deployedImages;
    private final Float currentWeight;
    private final Float desiredWeight;
    private final Integer currentInstanceCount;
    private final Integer desiredInstanceCount;

    private ProductionVariantSummary(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.deployedImages = builder.deployedImages;
        this.currentWeight = builder.currentWeight;
        this.desiredWeight = builder.desiredWeight;
        this.currentInstanceCount = builder.currentInstanceCount;
        this.desiredInstanceCount = builder.desiredInstanceCount;
    }

    public String variantName() {
        return this.variantName;
    }

    public List<DeployedImage> deployedImages() {
        return this.deployedImages;
    }

    public Float currentWeight() {
        return this.currentWeight;
    }

    public Float desiredWeight() {
        return this.desiredWeight;
    }

    public Integer currentInstanceCount() {
        return this.currentInstanceCount;
    }

    public Integer desiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployedImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantSummary)) {
            return false;
        }
        ProductionVariantSummary other = (ProductionVariantSummary)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.deployedImages(), other.deployedImages()) && Objects.equals(this.currentWeight(), other.currentWeight()) && Objects.equals(this.desiredWeight(), other.desiredWeight()) && Objects.equals(this.currentInstanceCount(), other.currentInstanceCount()) && Objects.equals(this.desiredInstanceCount(), other.desiredInstanceCount());
    }

    public String toString() {
        return ToString.builder((String)"ProductionVariantSummary").add("VariantName", (Object)this.variantName()).add("DeployedImages", this.deployedImages()).add("CurrentWeight", (Object)this.currentWeight()).add("DesiredWeight", (Object)this.desiredWeight()).add("CurrentInstanceCount", (Object)this.currentInstanceCount()).add("DesiredInstanceCount", (Object)this.desiredInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "DeployedImages": {
                return Optional.ofNullable(clazz.cast(this.deployedImages()));
            }
            case "CurrentWeight": {
                return Optional.ofNullable(clazz.cast(this.currentWeight()));
            }
            case "DesiredWeight": {
                return Optional.ofNullable(clazz.cast(this.desiredWeight()));
            }
            case "CurrentInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceCount()));
            }
            case "DesiredInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductionVariantSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private List<DeployedImage> deployedImages = DefaultSdkAutoConstructList.getInstance();
        private Float currentWeight;
        private Float desiredWeight;
        private Integer currentInstanceCount;
        private Integer desiredInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantSummary model) {
            this.variantName(model.variantName);
            this.deployedImages(model.deployedImages);
            this.currentWeight(model.currentWeight);
            this.desiredWeight(model.desiredWeight);
            this.currentInstanceCount(model.currentInstanceCount);
            this.desiredInstanceCount(model.desiredInstanceCount);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        public final Collection<DeployedImage.Builder> getDeployedImages() {
            return this.deployedImages != null ? (Collection)this.deployedImages.stream().map(DeployedImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployedImages(Collection<DeployedImage> deployedImages) {
            this.deployedImages = DeployedImagesCopier.copy(deployedImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployedImages(DeployedImage ... deployedImages) {
            this.deployedImages(Arrays.asList(deployedImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployedImages(Consumer<DeployedImage.Builder> ... deployedImages) {
            this.deployedImages(Stream.of(deployedImages).map(c -> (DeployedImage)((DeployedImage.Builder)DeployedImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeployedImages(Collection<DeployedImage.BuilderImpl> deployedImages) {
            this.deployedImages = DeployedImagesCopier.copyFromBuilder(deployedImages);
        }

        public final Float getCurrentWeight() {
            return this.currentWeight;
        }

        @Override
        public final Builder currentWeight(Float currentWeight) {
            this.currentWeight = currentWeight;
            return this;
        }

        public final void setCurrentWeight(Float currentWeight) {
            this.currentWeight = currentWeight;
        }

        public final Float getDesiredWeight() {
            return this.desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        public final Integer getCurrentInstanceCount() {
            return this.currentInstanceCount;
        }

        @Override
        public final Builder currentInstanceCount(Integer currentInstanceCount) {
            this.currentInstanceCount = currentInstanceCount;
            return this;
        }

        public final void setCurrentInstanceCount(Integer currentInstanceCount) {
            this.currentInstanceCount = currentInstanceCount;
        }

        public final Integer getDesiredInstanceCount() {
            return this.desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        public ProductionVariantSummary build() {
            return new ProductionVariantSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductionVariantSummary> {
        public Builder variantName(String var1);

        public Builder deployedImages(Collection<DeployedImage> var1);

        public Builder deployedImages(DeployedImage ... var1);

        public Builder deployedImages(Consumer<DeployedImage.Builder> ... var1);

        public Builder currentWeight(Float var1);

        public Builder desiredWeight(Float var1);

        public Builder currentInstanceCount(Integer var1);

        public Builder desiredInstanceCount(Integer var1);
    }
}

