/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.ObjectiveStatusCountersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectiveStatusCounters
implements StructuredPojo,
ToCopyableBuilder<Builder, ObjectiveStatusCounters> {
    private final Integer succeeded;
    private final Integer pending;
    private final Integer failed;

    private ObjectiveStatusCounters(BuilderImpl builder) {
        this.succeeded = builder.succeeded;
        this.pending = builder.pending;
        this.failed = builder.failed;
    }

    public Integer succeeded() {
        return this.succeeded;
    }

    public Integer pending() {
        return this.pending;
    }

    public Integer failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectiveStatusCounters)) {
            return false;
        }
        ObjectiveStatusCounters other = (ObjectiveStatusCounters)obj;
        return Objects.equals(this.succeeded(), other.succeeded()) && Objects.equals(this.pending(), other.pending()) && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        return ToString.builder((String)"ObjectiveStatusCounters").add("Succeeded", (Object)this.succeeded()).add("Pending", (Object)this.pending()).add("Failed", (Object)this.failed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectiveStatusCountersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer succeeded;
        private Integer pending;
        private Integer failed;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectiveStatusCounters model) {
            this.succeeded(model.succeeded);
            this.pending(model.pending);
            this.failed(model.failed);
        }

        public final Integer getSucceeded() {
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Integer succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Integer succeeded) {
            this.succeeded = succeeded;
        }

        public final Integer getPending() {
            return this.pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        public final Integer getFailed() {
            return this.failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        public ObjectiveStatusCounters build() {
            return new ObjectiveStatusCounters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectiveStatusCounters> {
        public Builder succeeded(Integer var1);

        public Builder pending(Integer var1);

        public Builder failed(Integer var1);
    }
}

