/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.IntegerParameterRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerParameterRange
implements StructuredPojo,
ToCopyableBuilder<Builder, IntegerParameterRange> {
    private final String name;
    private final String minValue;
    private final String maxValue;

    private IntegerParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    public String name() {
        return this.name;
    }

    public String minValue() {
        return this.minValue;
    }

    public String maxValue() {
        return this.maxValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerParameterRange)) {
            return false;
        }
        IntegerParameterRange other = (IntegerParameterRange)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue());
    }

    public String toString() {
        return ToString.builder((String)"IntegerParameterRange").add("Name", (Object)this.name()).add("MinValue", (Object)this.minValue()).add("MaxValue", (Object)this.maxValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntegerParameterRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String minValue;
        private String maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerParameterRange model) {
            this.name(model.name);
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMinValue() {
            return this.minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public final String getMaxValue() {
            return this.maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public IntegerParameterRange build() {
            return new IntegerParameterRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IntegerParameterRange> {
        public Builder name(String var1);

        public Builder minValue(String var1);

        public Builder maxValue(String var1);
    }
}

