/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters;
import software.amazon.awssdk.services.sagemaker.transform.HyperParameterTuningJobSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, HyperParameterTuningJobSummary> {
    private final String hyperParameterTuningJobName;
    private final String hyperParameterTuningJobArn;
    private final String hyperParameterTuningJobStatus;
    private final String strategy;
    private final Instant creationTime;
    private final Instant hyperParameterTuningEndTime;
    private final Instant lastModifiedTime;
    private final TrainingJobStatusCounters trainingJobStatusCounters;
    private final ObjectiveStatusCounters objectiveStatusCounters;
    private final ResourceLimits resourceLimits;

    private HyperParameterTuningJobSummary(BuilderImpl builder) {
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.strategy = builder.strategy;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.resourceLimits = builder.resourceLimits;
    }

    public String hyperParameterTuningJobName() {
        return this.hyperParameterTuningJobName;
    }

    public String hyperParameterTuningJobArn() {
        return this.hyperParameterTuningJobArn;
    }

    public HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(this.hyperParameterTuningJobStatus);
    }

    public String hyperParameterTuningJobStatusAsString() {
        return this.hyperParameterTuningJobStatus;
    }

    public HyperParameterTuningJobStrategyType strategy() {
        return HyperParameterTuningJobStrategyType.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant hyperParameterTuningEndTime() {
        return this.hyperParameterTuningEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TrainingJobStatusCounters trainingJobStatusCounters() {
        return this.trainingJobStatusCounters;
    }

    public ObjectiveStatusCounters objectiveStatusCounters() {
        return this.objectiveStatusCounters;
    }

    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLimits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobSummary)) {
            return false;
        }
        HyperParameterTuningJobSummary other = (HyperParameterTuningJobSummary)obj;
        return Objects.equals(this.hyperParameterTuningJobName(), other.hyperParameterTuningJobName()) && Objects.equals(this.hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn()) && Objects.equals(this.hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trainingJobStatusCounters(), other.trainingJobStatusCounters()) && Objects.equals(this.objectiveStatusCounters(), other.objectiveStatusCounters()) && Objects.equals(this.resourceLimits(), other.resourceLimits());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTuningJobSummary").add("HyperParameterTuningJobName", (Object)this.hyperParameterTuningJobName()).add("HyperParameterTuningJobArn", (Object)this.hyperParameterTuningJobArn()).add("HyperParameterTuningJobStatus", (Object)this.hyperParameterTuningJobStatusAsString()).add("Strategy", (Object)this.strategyAsString()).add("CreationTime", (Object)this.creationTime()).add("HyperParameterTuningEndTime", (Object)this.hyperParameterTuningEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrainingJobStatusCounters", (Object)this.trainingJobStatusCounters()).add("ObjectiveStatusCounters", (Object)this.objectiveStatusCounters()).add("ResourceLimits", (Object)this.resourceLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HyperParameterTuningJobName": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobName()));
            }
            case "HyperParameterTuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobArn()));
            }
            case "HyperParameterTuningJobStatus": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobStatusAsString()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HyperParameterTuningEndTime": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TrainingJobStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusCounters()));
            }
            case "ObjectiveStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusCounters()));
            }
            case "ResourceLimits": {
                return Optional.ofNullable(clazz.cast(this.resourceLimits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTuningJobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String hyperParameterTuningJobName;
        private String hyperParameterTuningJobArn;
        private String hyperParameterTuningJobStatus;
        private String strategy;
        private Instant creationTime;
        private Instant hyperParameterTuningEndTime;
        private Instant lastModifiedTime;
        private TrainingJobStatusCounters trainingJobStatusCounters;
        private ObjectiveStatusCounters objectiveStatusCounters;
        private ResourceLimits resourceLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobSummary model) {
            this.hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            this.hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            this.hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            this.strategy(model.strategy);
            this.creationTime(model.creationTime);
            this.hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trainingJobStatusCounters(model.trainingJobStatusCounters);
            this.objectiveStatusCounters(model.objectiveStatusCounters);
            this.resourceLimits(model.resourceLimits);
        }

        public final String getHyperParameterTuningJobName() {
            return this.hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final String getHyperParameterTuningJobArn() {
            return this.hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        public final String getHyperParameterTuningJobStatus() {
            return this.hyperParameterTuningJobStatus;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus.toString());
            return this;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(HyperParameterTuningJobStrategyType strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return this.hyperParameterTuningEndTime;
        }

        @Override
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return this.trainingJobStatusCounters != null ? this.trainingJobStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return this.objectiveStatusCounters != null ? this.objectiveStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        public final ResourceLimits.Builder getResourceLimits() {
            return this.resourceLimits != null ? this.resourceLimits.toBuilder() : null;
        }

        @Override
        public final Builder resourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        public final void setResourceLimits(ResourceLimits.BuilderImpl resourceLimits) {
            this.resourceLimits = resourceLimits != null ? resourceLimits.build() : null;
        }

        public HyperParameterTuningJobSummary build() {
            return new HyperParameterTuningJobSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HyperParameterTuningJobSummary> {
        public Builder hyperParameterTuningJobName(String var1);

        public Builder hyperParameterTuningJobArn(String var1);

        public Builder hyperParameterTuningJobStatus(String var1);

        public Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus var1);

        public Builder strategy(String var1);

        public Builder strategy(HyperParameterTuningJobStrategyType var1);

        public Builder creationTime(Instant var1);

        public Builder hyperParameterTuningEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trainingJobStatusCounters(TrainingJobStatusCounters var1);

        default public Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return this.trainingJobStatusCounters((TrainingJobStatusCounters)((TrainingJobStatusCounters.Builder)TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters)).build());
        }

        public Builder objectiveStatusCounters(ObjectiveStatusCounters var1);

        default public Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return this.objectiveStatusCounters((ObjectiveStatusCounters)((ObjectiveStatusCounters.Builder)ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters)).build());
        }

        public Builder resourceLimits(ResourceLimits var1);

        default public Builder resourceLimits(Consumer<ResourceLimits.Builder> resourceLimits) {
            return this.resourceLimits((ResourceLimits)((ResourceLimits.Builder)ResourceLimits.builder().applyMutation(resourceLimits)).build());
        }
    }
}

