/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjective;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType;
import software.amazon.awssdk.services.sagemaker.model.ParameterRanges;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;
import software.amazon.awssdk.services.sagemaker.transform.HyperParameterTuningJobConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, HyperParameterTuningJobConfig> {
    private final String strategy;
    private final HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
    private final ResourceLimits resourceLimits;
    private final ParameterRanges parameterRanges;

    private HyperParameterTuningJobConfig(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.hyperParameterTuningJobObjective = builder.hyperParameterTuningJobObjective;
        this.resourceLimits = builder.resourceLimits;
        this.parameterRanges = builder.parameterRanges;
    }

    public HyperParameterTuningJobStrategyType strategy() {
        return HyperParameterTuningJobStrategyType.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    public HyperParameterTuningJobObjective hyperParameterTuningJobObjective() {
        return this.hyperParameterTuningJobObjective;
    }

    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    public ParameterRanges parameterRanges() {
        return this.parameterRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterRanges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobConfig)) {
            return false;
        }
        HyperParameterTuningJobConfig other = (HyperParameterTuningJobConfig)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.hyperParameterTuningJobObjective(), other.hyperParameterTuningJobObjective()) && Objects.equals(this.resourceLimits(), other.resourceLimits()) && Objects.equals(this.parameterRanges(), other.parameterRanges());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTuningJobConfig").add("Strategy", (Object)this.strategyAsString()).add("HyperParameterTuningJobObjective", (Object)this.hyperParameterTuningJobObjective()).add("ResourceLimits", (Object)this.resourceLimits()).add("ParameterRanges", (Object)this.parameterRanges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "HyperParameterTuningJobObjective": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobObjective()));
            }
            case "ResourceLimits": {
                return Optional.ofNullable(clazz.cast(this.resourceLimits()));
            }
            case "ParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.parameterRanges()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTuningJobConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
        private ResourceLimits resourceLimits;
        private ParameterRanges parameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobConfig model) {
            this.strategy(model.strategy);
            this.hyperParameterTuningJobObjective(model.hyperParameterTuningJobObjective);
            this.resourceLimits(model.resourceLimits);
            this.parameterRanges(model.parameterRanges);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(HyperParameterTuningJobStrategyType strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final HyperParameterTuningJobObjective.Builder getHyperParameterTuningJobObjective() {
            return this.hyperParameterTuningJobObjective != null ? this.hyperParameterTuningJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective;
            return this;
        }

        public final void setHyperParameterTuningJobObjective(HyperParameterTuningJobObjective.BuilderImpl hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective != null ? hyperParameterTuningJobObjective.build() : null;
        }

        public final ResourceLimits.Builder getResourceLimits() {
            return this.resourceLimits != null ? this.resourceLimits.toBuilder() : null;
        }

        @Override
        public final Builder resourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        public final void setResourceLimits(ResourceLimits.BuilderImpl resourceLimits) {
            this.resourceLimits = resourceLimits != null ? resourceLimits.build() : null;
        }

        public final ParameterRanges.Builder getParameterRanges() {
            return this.parameterRanges != null ? this.parameterRanges.toBuilder() : null;
        }

        @Override
        public final Builder parameterRanges(ParameterRanges parameterRanges) {
            this.parameterRanges = parameterRanges;
            return this;
        }

        public final void setParameterRanges(ParameterRanges.BuilderImpl parameterRanges) {
            this.parameterRanges = parameterRanges != null ? parameterRanges.build() : null;
        }

        public HyperParameterTuningJobConfig build() {
            return new HyperParameterTuningJobConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HyperParameterTuningJobConfig> {
        public Builder strategy(String var1);

        public Builder strategy(HyperParameterTuningJobStrategyType var1);

        public Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective var1);

        default public Builder hyperParameterTuningJobObjective(Consumer<HyperParameterTuningJobObjective.Builder> hyperParameterTuningJobObjective) {
            return this.hyperParameterTuningJobObjective((HyperParameterTuningJobObjective)((HyperParameterTuningJobObjective.Builder)HyperParameterTuningJobObjective.builder().applyMutation(hyperParameterTuningJobObjective)).build());
        }

        public Builder resourceLimits(ResourceLimits var1);

        default public Builder resourceLimits(Consumer<ResourceLimits.Builder> resourceLimits) {
            return this.resourceLimits((ResourceLimits)((ResourceLimits.Builder)ResourceLimits.builder().applyMutation(resourceLimits)).build());
        }

        public Builder parameterRanges(ParameterRanges var1);

        default public Builder parameterRanges(Consumer<ParameterRanges.Builder> parameterRanges) {
            return this.parameterRanges((ParameterRanges)((ParameterRanges.Builder)ParameterRanges.builder().applyMutation(parameterRanges)).build());
        }
    }
}

