/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEndpointsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListEndpointsResponse> {
    private final List<EndpointSummary> endpoints;
    private final String nextToken;

    private ListEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    public List<EndpointSummary> endpoints() {
        return this.endpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsResponse)) {
            return false;
        }
        ListEndpointsResponse other = (ListEndpointsResponse)((Object)obj);
        return Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointsResponse").add("Endpoints", this.endpoints()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<EndpointSummary> endpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsResponse model) {
            super(model);
            this.endpoints(model.endpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<EndpointSummary.Builder> getEndpoints() {
            return this.endpoints != null ? (Collection)this.endpoints.stream().map(EndpointSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<EndpointSummary> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(EndpointSummary ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<EndpointSummary.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (EndpointSummary)((EndpointSummary.Builder)EndpointSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<EndpointSummary.BuilderImpl> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsResponse build() {
            return new ListEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, ListEndpointsResponse> {
        public Builder endpoints(Collection<EndpointSummary> var1);

        public Builder endpoints(EndpointSummary ... var1);

        public Builder endpoints(Consumer<EndpointSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

