/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.DesiredWeightAndCapacityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DesiredWeightAndCapacity
implements StructuredPojo,
ToCopyableBuilder<Builder, DesiredWeightAndCapacity> {
    private final String variantName;
    private final Float desiredWeight;
    private final Integer desiredInstanceCount;

    private DesiredWeightAndCapacity(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.desiredWeight = builder.desiredWeight;
        this.desiredInstanceCount = builder.desiredInstanceCount;
    }

    public String variantName() {
        return this.variantName;
    }

    public Float desiredWeight() {
        return this.desiredWeight;
    }

    public Integer desiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredWeightAndCapacity)) {
            return false;
        }
        DesiredWeightAndCapacity other = (DesiredWeightAndCapacity)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.desiredWeight(), other.desiredWeight()) && Objects.equals(this.desiredInstanceCount(), other.desiredInstanceCount());
    }

    public String toString() {
        return ToString.builder((String)"DesiredWeightAndCapacity").add("VariantName", (Object)this.variantName()).add("DesiredWeight", (Object)this.desiredWeight()).add("DesiredInstanceCount", (Object)this.desiredInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "DesiredWeight": {
                return Optional.ofNullable(clazz.cast(this.desiredWeight()));
            }
            case "DesiredInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DesiredWeightAndCapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private Float desiredWeight;
        private Integer desiredInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredWeightAndCapacity model) {
            this.variantName(model.variantName);
            this.desiredWeight(model.desiredWeight);
            this.desiredInstanceCount(model.desiredInstanceCount);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        public final Float getDesiredWeight() {
            return this.desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        public final Integer getDesiredInstanceCount() {
            return this.desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        public DesiredWeightAndCapacity build() {
            return new DesiredWeightAndCapacity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DesiredWeightAndCapacity> {
        public Builder variantName(String var1);

        public Builder desiredWeight(Float var1);

        public Builder desiredInstanceCount(Integer var1);
    }
}

