/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointConfigResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateModelResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedNotebookInstanceUrlRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreatePresignedNotebookInstanceUrlResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointConfigResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteModelResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointConfigRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointConfigResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeModelResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.DescribeTrainingJobResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointConfigsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointConfigsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListEndpointsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListModelsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstancesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListNotebookInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.ListTrainingJobsResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StartNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.StopTrainingJobResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointWeightsAndCapacitiesRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateEndpointWeightsAndCapacitiesResponseUnmarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceRequestMarshaller;
import software.amazon.awssdk.services.sagemaker.transform.UpdateNotebookInstanceResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSageMakerAsyncClient
implements SageMakerAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultSageMakerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "sagemaker";
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEndpointConfigResponse> createEndpointConfig(CreateEndpointConfigRequest createEndpointConfigRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEndpointConfigResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateEndpointConfigRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNotebookInstanceResponse> createNotebookInstance(CreateNotebookInstanceRequest createNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePresignedNotebookInstanceUrlResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePresignedNotebookInstanceUrlRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPresignedNotebookInstanceUrlRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTrainingJobResponse> createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTrainingJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateTrainingJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTrainingJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointConfigResponse> deleteEndpointConfig(DeleteEndpointConfigRequest deleteEndpointConfigRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEndpointConfigResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteEndpointConfigRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNotebookInstanceResponse> deleteNotebookInstance(DeleteNotebookInstanceRequest deleteNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointConfigResponse> describeEndpointConfig(DescribeEndpointConfigRequest describeEndpointConfigRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointConfigResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEndpointConfigRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNotebookInstanceResponse> describeNotebookInstance(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTrainingJobResponse> describeTrainingJob(DescribeTrainingJobRequest describeTrainingJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTrainingJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTrainingJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTrainingJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEndpointConfigsResponse> listEndpointConfigs(ListEndpointConfigsRequest listEndpointConfigsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEndpointConfigsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListEndpointConfigsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointConfigsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListEndpointConfigsPublisher listEndpointConfigsPaginator(ListEndpointConfigsRequest listEndpointConfigsRequest) {
        return new ListEndpointConfigsPublisher(this, this.applyPaginatorUserAgent(listEndpointConfigsRequest));
    }

    @Override
    public CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEndpointsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListEndpointsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListEndpointsPublisher listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest) {
        return new ListEndpointsPublisher(this, this.applyPaginatorUserAgent(listEndpointsRequest));
    }

    @Override
    public CompletableFuture<ListModelsResponse> listModels(ListModelsRequest listModelsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListModelsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListModelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listModelsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListModelsPublisher listModelsPaginator(ListModelsRequest listModelsRequest) {
        return new ListModelsPublisher(this, this.applyPaginatorUserAgent(listModelsRequest));
    }

    @Override
    public CompletableFuture<ListNotebookInstancesResponse> listNotebookInstances(ListNotebookInstancesRequest listNotebookInstancesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNotebookInstancesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListNotebookInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotebookInstancesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListNotebookInstancesPublisher listNotebookInstancesPaginator(ListNotebookInstancesRequest listNotebookInstancesRequest) {
        return new ListNotebookInstancesPublisher(this, this.applyPaginatorUserAgent(listNotebookInstancesRequest));
    }

    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        return new ListTagsPublisher(this, this.applyPaginatorUserAgent(listTagsRequest));
    }

    @Override
    public CompletableFuture<ListTrainingJobsResponse> listTrainingJobs(ListTrainingJobsRequest listTrainingJobsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTrainingJobsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTrainingJobsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTrainingJobsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTrainingJobsPublisher listTrainingJobsPaginator(ListTrainingJobsRequest listTrainingJobsRequest) {
        return new ListTrainingJobsPublisher(this, this.applyPaginatorUserAgent(listTrainingJobsRequest));
    }

    @Override
    public CompletableFuture<StartNotebookInstanceResponse> startNotebookInstance(StartNotebookInstanceRequest startNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopNotebookInstanceResponse> stopNotebookInstance(StopNotebookInstanceRequest stopNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTrainingJobResponse> stopTrainingJob(StopTrainingJobRequest stopTrainingJobRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopTrainingJobResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopTrainingJobRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopTrainingJobRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointWeightsAndCapacitiesResponse> updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest updateEndpointWeightsAndCapacitiesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEndpointWeightsAndCapacitiesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateEndpointWeightsAndCapacitiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointWeightsAndCapacitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNotebookInstanceResponse> updateNotebookInstance(UpdateNotebookInstanceRequest updateNotebookInstanceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotebookInstanceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateNotebookInstanceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNotebookInstanceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(SageMakerException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUse").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceeded").withModeledClass(ResourceLimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private <T extends SageMakerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SageMakerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

