/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ModelSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModelSummaryMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").isBinary(false).build();
    private static final MarshallingInfo<String> MODELARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final ModelSummaryMarshaller INSTANCE = new ModelSummaryMarshaller();

    private ModelSummaryMarshaller() {
    }

    public static ModelSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModelSummary modelSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)modelSummary, (String)"modelSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modelSummary.modelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.modelArn(), MODELARN_BINDING);
            protocolMarshaller.marshall((Object)modelSummary.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

