/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.transform.CreateTrainingJobRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateTrainingJobRequestMarshaller
implements Marshaller<Request<CreateTrainingJobRequest>, CreateTrainingJobRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("SageMaker.CreateTrainingJob").serviceName("SageMaker").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateTrainingJobRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateTrainingJobRequest> marshall(CreateTrainingJobRequest createTrainingJobRequest) {
        Validate.paramNotNull((Object)((Object)createTrainingJobRequest), (String)"createTrainingJobRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createTrainingJobRequest);
            protocolMarshaller.startMarshalling();
            CreateTrainingJobRequestModelMarshaller.getInstance().marshall(createTrainingJobRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

