/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;

public class ListTrainingJobsPublisher
implements SdkPublisher<ListTrainingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTrainingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrainingJobsPublisher(SageMakerAsyncClient client, ListTrainingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrainingJobsPublisher(SageMakerAsyncClient client, ListTrainingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrainingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrainingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListTrainingJobsPublisher resume(ListTrainingJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTrainingJobsPublisher(this.client, (ListTrainingJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTrainingJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTrainingJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTrainingJobsResponseFetcher
    implements AsyncPageFetcher<ListTrainingJobsResponse> {
        private ListTrainingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListTrainingJobsResponse> nextPage(ListTrainingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingJobsPublisher.this.client.listTrainingJobs(ListTrainingJobsPublisher.this.firstRequest);
            }
            return ListTrainingJobsPublisher.this.client.listTrainingJobs((ListTrainingJobsRequest)((Object)ListTrainingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

