/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;

public class ListNotebookInstancesPublisher
implements SdkPublisher<ListNotebookInstancesResponse> {
    private final SageMakerAsyncClient client;
    private final ListNotebookInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotebookInstancesPublisher(SageMakerAsyncClient client, ListNotebookInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotebookInstancesPublisher(SageMakerAsyncClient client, ListNotebookInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotebookInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotebookInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListNotebookInstancesPublisher resume(ListNotebookInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListNotebookInstancesPublisher(this.client, (ListNotebookInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListNotebookInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListNotebookInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListNotebookInstancesResponseFetcher
    implements AsyncPageFetcher<ListNotebookInstancesResponse> {
        private ListNotebookInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListNotebookInstancesResponse> nextPage(ListNotebookInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookInstancesPublisher.this.client.listNotebookInstances(ListNotebookInstancesPublisher.this.firstRequest);
            }
            return ListNotebookInstancesPublisher.this.client.listNotebookInstances((ListNotebookInstancesRequest)((Object)ListNotebookInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

