/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacityListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEndpointWeightsAndCapacitiesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
    private final String endpointName;
    private final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities;

    private UpdateEndpointWeightsAndCapacitiesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.desiredWeightsAndCapacities = builder.desiredWeightsAndCapacities;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public List<DesiredWeightAndCapacity> desiredWeightsAndCapacities() {
        return this.desiredWeightsAndCapacities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeightsAndCapacities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointWeightsAndCapacitiesRequest)) {
            return false;
        }
        UpdateEndpointWeightsAndCapacitiesRequest other = (UpdateEndpointWeightsAndCapacitiesRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.desiredWeightsAndCapacities(), other.desiredWeightsAndCapacities());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointWeightsAndCapacitiesRequest").add("EndpointName", (Object)this.endpointName()).add("DesiredWeightsAndCapacities", this.desiredWeightsAndCapacities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.of(clazz.cast(this.endpointName()));
            }
            case "DesiredWeightsAndCapacities": {
                return Optional.of(clazz.cast(this.desiredWeightsAndCapacities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private List<DesiredWeightAndCapacity> desiredWeightsAndCapacities;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointWeightsAndCapacitiesRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.desiredWeightsAndCapacities(model.desiredWeightsAndCapacities);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final Collection<DesiredWeightAndCapacity.Builder> getDesiredWeightsAndCapacities() {
            return this.desiredWeightsAndCapacities != null ? (Collection)this.desiredWeightsAndCapacities.stream().map(DesiredWeightAndCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copy(desiredWeightsAndCapacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Arrays.asList(desiredWeightsAndCapacities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Stream.of(desiredWeightsAndCapacities).map(c -> (DesiredWeightAndCapacity)((DesiredWeightAndCapacity.Builder)DesiredWeightAndCapacity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDesiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity.BuilderImpl> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copyFromBuilder(desiredWeightsAndCapacities);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointWeightsAndCapacitiesRequest build() {
            return new UpdateEndpointWeightsAndCapacitiesRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
        public Builder endpointName(String var1);

        public Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> var1);

        public Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... var1);

        public Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

