/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.sagemaker.model.ModelSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListModelsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelsResponse> {
    private final List<ModelSummary> models;
    private final String nextToken;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.models = builder.models;
        this.nextToken = builder.nextToken;
    }

    public List<ModelSummary> models() {
        return this.models;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.models());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse)((Object)obj);
        return Objects.equals(this.models(), other.models()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListModelsResponse").add("Models", this.models()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Models": {
                return Optional.of(clazz.cast(this.models()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelSummary> models;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            this.models(model.models);
            this.nextToken(model.nextToken);
        }

        public final Collection<ModelSummary.Builder> getModels() {
            return this.models != null ? (Collection)this.models.stream().map(ModelSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<ModelSummary> models) {
            this.models = ModelSummaryListCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(ModelSummary ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<ModelSummary.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (ModelSummary)((ModelSummary.Builder)ModelSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<ModelSummary.BuilderImpl> models) {
            this.models = ModelSummaryListCopier.copyFromBuilder(models);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, ListModelsResponse> {
        public Builder models(Collection<ModelSummary> var1);

        public Builder models(ModelSummary ... var1);

        public Builder models(Consumer<ModelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

