/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey;
import software.amazon.awssdk.services.sagemaker.model.OrderKey;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEndpointConfigsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListEndpointConfigsRequest> {
    private final String sortBy;
    private final String sortOrder;
    private final String nextToken;
    private final Integer maxResults;
    private final String nameContains;
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;

    private ListEndpointConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
    }

    public EndpointConfigSortKey sortBy() {
        return EndpointConfigSortKey.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public OrderKey sortOrder() {
        return OrderKey.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nameContains() {
        return this.nameContains;
    }

    public Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointConfigsRequest)) {
            return false;
        }
        ListEndpointConfigsRequest other = (ListEndpointConfigsRequest)((Object)obj);
        return Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointConfigsRequest").add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("NameContains", (Object)this.nameContains()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SortBy": {
                return Optional.of(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.of(clazz.cast(this.sortOrderAsString()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NameContains": {
                return Optional.of(clazz.cast(this.nameContains()));
            }
            case "CreationTimeBefore": {
                return Optional.of(clazz.cast(this.creationTimeBefore()));
            }
            case "CreationTimeAfter": {
                return Optional.of(clazz.cast(this.creationTimeAfter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String sortBy;
        private String sortOrder;
        private String nextToken;
        private Integer maxResults;
        private String nameContains;
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointConfigsRequest model) {
            super(model);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.nameContains(model.nameContains);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(EndpointConfigSortKey sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(OrderKey sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListEndpointConfigsRequest build() {
            return new ListEndpointConfigsRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, ListEndpointConfigsRequest> {
        public Builder sortBy(String var1);

        public Builder sortBy(EndpointConfigSortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(OrderKey var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder nameContains(String var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

