/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.s3vectors.DefaultS3VectorsAsyncClientBuilder;
import software.amazon.awssdk.services.s3vectors.S3VectorsAsyncClientBuilder;
import software.amazon.awssdk.services.s3vectors.S3VectorsServiceClientConfiguration;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.GetIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.GetIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;
import software.amazon.awssdk.services.s3vectors.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.TagResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.TagResourceResponse;
import software.amazon.awssdk.services.s3vectors.model.UntagResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.UntagResourceResponse;
import software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher;

@SdkPublicApi
@ThreadSafe
public interface S3VectorsAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "s3vectors";
    public static final String SERVICE_METADATA_ID = "s3vectors";

    default public CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return this.createIndex((CreateIndexRequest)((Object)((CreateIndexRequest.Builder)CreateIndexRequest.builder().applyMutation(createIndexRequest)).build()));
    }

    default public CompletableFuture<CreateVectorBucketResponse> createVectorBucket(CreateVectorBucketRequest createVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateVectorBucketResponse> createVectorBucket(Consumer<CreateVectorBucketRequest.Builder> createVectorBucketRequest) {
        return this.createVectorBucket((CreateVectorBucketRequest)((Object)((CreateVectorBucketRequest.Builder)CreateVectorBucketRequest.builder().applyMutation(createVectorBucketRequest)).build()));
    }

    default public CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteIndexResponse> deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) {
        return this.deleteIndex((DeleteIndexRequest)((Object)((DeleteIndexRequest.Builder)DeleteIndexRequest.builder().applyMutation(deleteIndexRequest)).build()));
    }

    default public CompletableFuture<DeleteVectorBucketResponse> deleteVectorBucket(DeleteVectorBucketRequest deleteVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVectorBucketResponse> deleteVectorBucket(Consumer<DeleteVectorBucketRequest.Builder> deleteVectorBucketRequest) {
        return this.deleteVectorBucket((DeleteVectorBucketRequest)((Object)((DeleteVectorBucketRequest.Builder)DeleteVectorBucketRequest.builder().applyMutation(deleteVectorBucketRequest)).build()));
    }

    default public CompletableFuture<DeleteVectorBucketPolicyResponse> deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest deleteVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVectorBucketPolicyResponse> deleteVectorBucketPolicy(Consumer<DeleteVectorBucketPolicyRequest.Builder> deleteVectorBucketPolicyRequest) {
        return this.deleteVectorBucketPolicy((DeleteVectorBucketPolicyRequest)((Object)((DeleteVectorBucketPolicyRequest.Builder)DeleteVectorBucketPolicyRequest.builder().applyMutation(deleteVectorBucketPolicyRequest)).build()));
    }

    default public CompletableFuture<DeleteVectorsResponse> deleteVectors(DeleteVectorsRequest deleteVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteVectorsResponse> deleteVectors(Consumer<DeleteVectorsRequest.Builder> deleteVectorsRequest) {
        return this.deleteVectors((DeleteVectorsRequest)((Object)((DeleteVectorsRequest.Builder)DeleteVectorsRequest.builder().applyMutation(deleteVectorsRequest)).build()));
    }

    default public CompletableFuture<GetIndexResponse> getIndex(GetIndexRequest getIndexRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetIndexResponse> getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) {
        return this.getIndex((GetIndexRequest)((Object)((GetIndexRequest.Builder)GetIndexRequest.builder().applyMutation(getIndexRequest)).build()));
    }

    default public CompletableFuture<GetVectorBucketResponse> getVectorBucket(GetVectorBucketRequest getVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVectorBucketResponse> getVectorBucket(Consumer<GetVectorBucketRequest.Builder> getVectorBucketRequest) {
        return this.getVectorBucket((GetVectorBucketRequest)((Object)((GetVectorBucketRequest.Builder)GetVectorBucketRequest.builder().applyMutation(getVectorBucketRequest)).build()));
    }

    default public CompletableFuture<GetVectorBucketPolicyResponse> getVectorBucketPolicy(GetVectorBucketPolicyRequest getVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVectorBucketPolicyResponse> getVectorBucketPolicy(Consumer<GetVectorBucketPolicyRequest.Builder> getVectorBucketPolicyRequest) {
        return this.getVectorBucketPolicy((GetVectorBucketPolicyRequest)((Object)((GetVectorBucketPolicyRequest.Builder)GetVectorBucketPolicyRequest.builder().applyMutation(getVectorBucketPolicyRequest)).build()));
    }

    default public CompletableFuture<GetVectorsResponse> getVectors(GetVectorsRequest getVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVectorsResponse> getVectors(Consumer<GetVectorsRequest.Builder> getVectorsRequest) {
        return this.getVectors((GetVectorsRequest)((Object)((GetVectorsRequest.Builder)GetVectorsRequest.builder().applyMutation(getVectorsRequest)).build()));
    }

    default public CompletableFuture<ListIndexesResponse> listIndexes(ListIndexesRequest listIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListIndexesResponse> listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return this.listIndexes((ListIndexesRequest)((Object)((ListIndexesRequest.Builder)ListIndexesRequest.builder().applyMutation(listIndexesRequest)).build()));
    }

    default public ListIndexesPublisher listIndexesPaginator(ListIndexesRequest listIndexesRequest) {
        return new ListIndexesPublisher(this, listIndexesRequest);
    }

    default public ListIndexesPublisher listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return this.listIndexesPaginator((ListIndexesRequest)((Object)((ListIndexesRequest.Builder)ListIndexesRequest.builder().applyMutation(listIndexesRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<ListVectorBucketsResponse> listVectorBuckets(ListVectorBucketsRequest listVectorBucketsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListVectorBucketsResponse> listVectorBuckets(Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) {
        return this.listVectorBuckets((ListVectorBucketsRequest)((Object)((ListVectorBucketsRequest.Builder)ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest)).build()));
    }

    default public ListVectorBucketsPublisher listVectorBucketsPaginator(ListVectorBucketsRequest listVectorBucketsRequest) {
        return new ListVectorBucketsPublisher(this, listVectorBucketsRequest);
    }

    default public ListVectorBucketsPublisher listVectorBucketsPaginator(Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) {
        return this.listVectorBucketsPaginator((ListVectorBucketsRequest)((Object)((ListVectorBucketsRequest.Builder)ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest)).build()));
    }

    default public CompletableFuture<ListVectorsResponse> listVectors(ListVectorsRequest listVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListVectorsResponse> listVectors(Consumer<ListVectorsRequest.Builder> listVectorsRequest) {
        return this.listVectors((ListVectorsRequest)((Object)((ListVectorsRequest.Builder)ListVectorsRequest.builder().applyMutation(listVectorsRequest)).build()));
    }

    default public ListVectorsPublisher listVectorsPaginator(ListVectorsRequest listVectorsRequest) {
        return new ListVectorsPublisher(this, listVectorsRequest);
    }

    default public ListVectorsPublisher listVectorsPaginator(Consumer<ListVectorsRequest.Builder> listVectorsRequest) {
        return this.listVectorsPaginator((ListVectorsRequest)((Object)((ListVectorsRequest.Builder)ListVectorsRequest.builder().applyMutation(listVectorsRequest)).build()));
    }

    default public CompletableFuture<PutVectorBucketPolicyResponse> putVectorBucketPolicy(PutVectorBucketPolicyRequest putVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutVectorBucketPolicyResponse> putVectorBucketPolicy(Consumer<PutVectorBucketPolicyRequest.Builder> putVectorBucketPolicyRequest) {
        return this.putVectorBucketPolicy((PutVectorBucketPolicyRequest)((Object)((PutVectorBucketPolicyRequest.Builder)PutVectorBucketPolicyRequest.builder().applyMutation(putVectorBucketPolicyRequest)).build()));
    }

    default public CompletableFuture<PutVectorsResponse> putVectors(PutVectorsRequest putVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutVectorsResponse> putVectors(Consumer<PutVectorsRequest.Builder> putVectorsRequest) {
        return this.putVectors((PutVectorsRequest)((Object)((PutVectorsRequest.Builder)PutVectorsRequest.builder().applyMutation(putVectorsRequest)).build()));
    }

    default public CompletableFuture<QueryVectorsResponse> queryVectors(QueryVectorsRequest queryVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<QueryVectorsResponse> queryVectors(Consumer<QueryVectorsRequest.Builder> queryVectorsRequest) {
        return this.queryVectors((QueryVectorsRequest)((Object)((QueryVectorsRequest.Builder)QueryVectorsRequest.builder().applyMutation(queryVectorsRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public S3VectorsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static S3VectorsAsyncClient create() {
        return (S3VectorsAsyncClient)S3VectorsAsyncClient.builder().build();
    }

    public static S3VectorsAsyncClientBuilder builder() {
        return new DefaultS3VectorsAsyncClientBuilder();
    }
}

