/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVectorsResponse extends S3VectorsResponse implements
        ToCopyableBuilder<GetVectorsResponse.Builder, GetVectorsResponse> {
    private static final SdkField<List<GetOutputVector>> VECTORS_FIELD = SdkField
            .<List<GetOutputVector>> builder(MarshallingType.LIST)
            .memberName("vectors")
            .getter(getter(GetVectorsResponse::vectors))
            .setter(setter(Builder::vectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetOutputVector> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetOutputVector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GetOutputVector> vectors;

    private GetVectorsResponse(BuilderImpl builder) {
        super(builder);
        this.vectors = builder.vectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVectors() {
        return vectors != null && !(vectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the vectors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVectors} method.
     * </p>
     * 
     * @return The attributes of the vectors.
     */
    public final List<GetOutputVector> vectors() {
        return vectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVectors() ? vectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorsResponse)) {
            return false;
        }
        GetVectorsResponse other = (GetVectorsResponse) obj;
        return hasVectors() == other.hasVectors() && Objects.equals(vectors(), other.vectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVectorsResponse").add("Vectors", hasVectors() ? vectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectors":
            return Optional.ofNullable(clazz.cast(vectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectors", VECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVectorsResponse, T> g) {
        return obj -> g.apply((GetVectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVectorsResponse> {
        /**
         * <p>
         * The attributes of the vectors.
         * </p>
         * 
         * @param vectors
         *        The attributes of the vectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectors(Collection<GetOutputVector> vectors);

        /**
         * <p>
         * The attributes of the vectors.
         * </p>
         * 
         * @param vectors
         *        The attributes of the vectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectors(GetOutputVector... vectors);

        /**
         * <p>
         * The attributes of the vectors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3vectors.model.GetOutputVector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.s3vectors.model.GetOutputVector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3vectors.model.GetOutputVector.Builder#build()} is called immediately
         * and its result is passed to {@link #vectors(List<GetOutputVector>)}.
         * 
         * @param vectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3vectors.model.GetOutputVector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectors(java.util.Collection<GetOutputVector>)
         */
        Builder vectors(Consumer<GetOutputVector.Builder>... vectors);
    }

    static final class BuilderImpl extends S3VectorsResponse.BuilderImpl implements Builder {
        private List<GetOutputVector> vectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorsResponse model) {
            super(model);
            vectors(model.vectors);
        }

        public final List<GetOutputVector.Builder> getVectors() {
            List<GetOutputVector.Builder> result = GetVectorsOutputListCopier.copyToBuilder(this.vectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectors(Collection<GetOutputVector.BuilderImpl> vectors) {
            this.vectors = GetVectorsOutputListCopier.copyFromBuilder(vectors);
        }

        @Override
        public final Builder vectors(Collection<GetOutputVector> vectors) {
            this.vectors = GetVectorsOutputListCopier.copy(vectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(GetOutputVector... vectors) {
            vectors(Arrays.asList(vectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(Consumer<GetOutputVector.Builder>... vectors) {
            vectors(Stream.of(vectors).map(c -> GetOutputVector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetVectorsResponse build() {
            return new GetVectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
