/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3vectors.S3VectorsClient;
import software.amazon.awssdk.services.s3vectors.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary;

public class ListVectorBucketsIterable
implements SdkIterable<ListVectorBucketsResponse> {
    private final S3VectorsClient client;
    private final ListVectorBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVectorBucketsIterable(S3VectorsClient client, ListVectorBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVectorBucketsResponseFetcher();
    }

    public Iterator<ListVectorBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VectorBucketSummary> vectorBuckets() {
        Function<ListVectorBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vectorBuckets() != null) {
                return response.vectorBuckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVectorBucketsResponseFetcher
    implements SyncPageFetcher<ListVectorBucketsResponse> {
        private ListVectorBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVectorBucketsResponse nextPage(ListVectorBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorBucketsIterable.this.client.listVectorBuckets(ListVectorBucketsIterable.this.firstRequest);
            }
            return ListVectorBucketsIterable.this.client.listVectorBuckets((ListVectorBucketsRequest)((Object)ListVectorBucketsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

