/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryVectorsRequest extends S3VectorsRequest implements
        ToCopyableBuilder<QueryVectorsRequest.Builder, QueryVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(QueryVectorsRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(QueryVectorsRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(QueryVectorsRequest::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("topK")
            .getter(getter(QueryVectorsRequest::topK)).setter(setter(Builder::topK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()).build();

    private static final SdkField<VectorData> QUERY_VECTOR_FIELD = SdkField.<VectorData> builder(MarshallingType.SDK_POJO)
            .memberName("queryVector").getter(getter(QueryVectorsRequest::queryVector)).setter(setter(Builder::queryVector))
            .constructor(VectorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVector").build()).build();

    private static final SdkField<Document> FILTER_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("filter").getter(getter(QueryVectorsRequest::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnMetadata").getter(getter(QueryVectorsRequest::returnMetadata))
            .setter(setter(Builder::returnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()).build();

    private static final SdkField<Boolean> RETURN_DISTANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnDistance").getter(getter(QueryVectorsRequest::returnDistance))
            .setter(setter(Builder::returnDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnDistance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            INDEX_NAME_FIELD, INDEX_ARN_FIELD, TOPK_FIELD, QUERY_VECTOR_FIELD, FILTER_FIELD, RETURN_METADATA_FIELD,
            RETURN_DISTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String indexName;

    private final String indexArn;

    private final Integer topK;

    private final VectorData queryVector;

    private final Document filter;

    private final Boolean returnMetadata;

    private final Boolean returnDistance;

    private QueryVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.topK = builder.topK;
        this.queryVector = builder.queryVector;
        this.filter = builder.filter;
        this.returnMetadata = builder.returnMetadata;
        this.returnDistance = builder.returnDistance;
    }

    /**
     * <p>
     * The name of the vector bucket that contains the vector index.
     * </p>
     * 
     * @return The name of the vector bucket that contains the vector index.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The name of the vector index that you want to query.
     * </p>
     * 
     * @return The name of the vector index that you want to query.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The ARN of the vector index that you want to query.
     * </p>
     * 
     * @return The ARN of the vector index that you want to query.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The number of results to return for each query.
     * </p>
     * 
     * @return The number of results to return for each query.
     */
    public final Integer topK() {
        return topK;
    }

    /**
     * <p>
     * The query vector. Ensure that the query vector has the same dimension as the dimension of the vector index that's
     * being queried. For example, if your vector index contains vectors with 384 dimensions, your query vector must
     * also have 384 dimensions.
     * </p>
     * 
     * @return The query vector. Ensure that the query vector has the same dimension as the dimension of the vector
     *         index that's being queried. For example, if your vector index contains vectors with 384 dimensions, your
     *         query vector must also have 384 dimensions.
     */
    public final VectorData queryVector() {
        return queryVector;
    }

    /**
     * <p>
     * Metadata filter to apply during the query. For more information about metadata keys, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html">Metadata
     * filtering</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * 
     * @return Metadata filter to apply during the query. For more information about metadata keys, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html">Metadata
     *         filtering</a> in the <i>Amazon S3 User Guide</i>.
     */
    public final Document filter() {
        return filter;
    }

    /**
     * <p>
     * Indicates whether to include metadata in the response. The default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to include metadata in the response. The default value is <code>false</code>.
     */
    public final Boolean returnMetadata() {
        return returnMetadata;
    }

    /**
     * <p>
     * Indicates whether to include the computed distance in the response. The default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to include the computed distance in the response. The default value is
     *         <code>false</code>.
     */
    public final Boolean returnDistance() {
        return returnDistance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(topK());
        hashCode = 31 * hashCode + Objects.hashCode(queryVector());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(returnMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(returnDistance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryVectorsRequest)) {
            return false;
        }
        QueryVectorsRequest other = (QueryVectorsRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexArn(), other.indexArn()) && Objects.equals(topK(), other.topK())
                && Objects.equals(queryVector(), other.queryVector()) && Objects.equals(filter(), other.filter())
                && Objects.equals(returnMetadata(), other.returnMetadata())
                && Objects.equals(returnDistance(), other.returnDistance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryVectorsRequest").add("VectorBucketName", vectorBucketName()).add("IndexName", indexName())
                .add("IndexArn", indexArn()).add("TopK", topK()).add("QueryVector", queryVector()).add("Filter", filter())
                .add("ReturnMetadata", returnMetadata()).add("ReturnDistance", returnDistance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "topK":
            return Optional.ofNullable(clazz.cast(topK()));
        case "queryVector":
            return Optional.ofNullable(clazz.cast(queryVector()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "returnMetadata":
            return Optional.ofNullable(clazz.cast(returnMetadata()));
        case "returnDistance":
            return Optional.ofNullable(clazz.cast(returnDistance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("queryVector", QUERY_VECTOR_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        map.put("returnDistance", RETURN_DISTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryVectorsRequest, T> g) {
        return obj -> g.apply((QueryVectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryVectorsRequest> {
        /**
         * <p>
         * The name of the vector bucket that contains the vector index.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket that contains the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The name of the vector index that you want to query.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The ARN of the vector index that you want to query.
         * </p>
         * 
         * @param indexArn
         *        The ARN of the vector index that you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The number of results to return for each query.
         * </p>
         * 
         * @param topK
         *        The number of results to return for each query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topK(Integer topK);

        /**
         * <p>
         * The query vector. Ensure that the query vector has the same dimension as the dimension of the vector index
         * that's being queried. For example, if your vector index contains vectors with 384 dimensions, your query
         * vector must also have 384 dimensions.
         * </p>
         * 
         * @param queryVector
         *        The query vector. Ensure that the query vector has the same dimension as the dimension of the vector
         *        index that's being queried. For example, if your vector index contains vectors with 384 dimensions,
         *        your query vector must also have 384 dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVector(VectorData queryVector);

        /**
         * <p>
         * The query vector. Ensure that the query vector has the same dimension as the dimension of the vector index
         * that's being queried. For example, if your vector index contains vectors with 384 dimensions, your query
         * vector must also have 384 dimensions.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorData.Builder} avoiding the need to
         * create one manually via {@link VectorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorData.Builder#build()} is called immediately and its result
         * is passed to {@link #queryVector(VectorData)}.
         * 
         * @param queryVector
         *        a consumer that will call methods on {@link VectorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryVector(VectorData)
         */
        default Builder queryVector(Consumer<VectorData.Builder> queryVector) {
            return queryVector(VectorData.builder().applyMutation(queryVector).build());
        }

        /**
         * <p>
         * Metadata filter to apply during the query. For more information about metadata keys, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html">Metadata
         * filtering</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param filter
         *        Metadata filter to apply during the query. For more information about metadata keys, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html"
         *        >Metadata filtering</a> in the <i>Amazon S3 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Document filter);

        /**
         * <p>
         * Indicates whether to include metadata in the response. The default value is <code>false</code>.
         * </p>
         * 
         * @param returnMetadata
         *        Indicates whether to include metadata in the response. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnMetadata(Boolean returnMetadata);

        /**
         * <p>
         * Indicates whether to include the computed distance in the response. The default value is <code>false</code>.
         * </p>
         * 
         * @param returnDistance
         *        Indicates whether to include the computed distance in the response. The default value is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnDistance(Boolean returnDistance);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String indexName;

        private String indexArn;

        private Integer topK;

        private VectorData queryVector;

        private Document filter;

        private Boolean returnMetadata;

        private Boolean returnDistance;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryVectorsRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            indexName(model.indexName);
            indexArn(model.indexArn);
            topK(model.topK);
            queryVector(model.queryVector);
            filter(model.filter);
            returnMetadata(model.returnMetadata);
            returnDistance(model.returnDistance);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Integer getTopK() {
            return topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final VectorData.Builder getQueryVector() {
            return queryVector != null ? queryVector.toBuilder() : null;
        }

        public final void setQueryVector(VectorData.BuilderImpl queryVector) {
            this.queryVector = queryVector != null ? queryVector.build() : null;
        }

        @Override
        public final Builder queryVector(VectorData queryVector) {
            this.queryVector = queryVector;
            return this;
        }

        public final Document getFilter() {
            return filter;
        }

        public final void setFilter(Document filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(Document filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        public final Boolean getReturnDistance() {
            return returnDistance;
        }

        public final void setReturnDistance(Boolean returnDistance) {
            this.returnDistance = returnDistance;
        }

        @Override
        public final Builder returnDistance(Boolean returnDistance) {
            this.returnDistance = returnDistance;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryVectorsRequest build() {
            return new QueryVectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
