/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndexesResponse extends S3VectorsResponse implements
        ToCopyableBuilder<ListIndexesResponse.Builder, ListIndexesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIndexesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<IndexSummary>> INDEXES_FIELD = SdkField
            .<List<IndexSummary>> builder(MarshallingType.LIST)
            .memberName("indexes")
            .getter(getter(ListIndexesResponse::indexes))
            .setter(setter(Builder::indexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IndexSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IndexSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INDEXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<IndexSummary> indexes;

    private ListIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.indexes = builder.indexes;
    }

    /**
     * <p>
     * The next pagination token.
     * </p>
     * 
     * @return The next pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Indexes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIndexes() {
        return indexes != null && !(indexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the vector indexes
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexes} method.
     * </p>
     * 
     * @return The attributes of the vector indexes
     */
    public final List<IndexSummary> indexes() {
        return indexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexes() ? indexes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexesResponse)) {
            return false;
        }
        ListIndexesResponse other = (ListIndexesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIndexes() == other.hasIndexes()
                && Objects.equals(indexes(), other.indexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndexesResponse").add("NextToken", nextToken())
                .add("Indexes", hasIndexes() ? indexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "indexes":
            return Optional.ofNullable(clazz.cast(indexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("indexes", INDEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndexesResponse, T> g) {
        return obj -> g.apply((ListIndexesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIndexesResponse> {
        /**
         * <p>
         * The next pagination token.
         * </p>
         * 
         * @param nextToken
         *        The next pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The attributes of the vector indexes
         * </p>
         * 
         * @param indexes
         *        The attributes of the vector indexes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexes(Collection<IndexSummary> indexes);

        /**
         * <p>
         * The attributes of the vector indexes
         * </p>
         * 
         * @param indexes
         *        The attributes of the vector indexes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexes(IndexSummary... indexes);

        /**
         * <p>
         * The attributes of the vector indexes
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3vectors.model.IndexSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.s3vectors.model.IndexSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3vectors.model.IndexSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #indexes(List<IndexSummary>)}.
         * 
         * @param indexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3vectors.model.IndexSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexes(java.util.Collection<IndexSummary>)
         */
        Builder indexes(Consumer<IndexSummary.Builder>... indexes);
    }

    static final class BuilderImpl extends S3VectorsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<IndexSummary> indexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexesResponse model) {
            super(model);
            nextToken(model.nextToken);
            indexes(model.indexes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IndexSummary.Builder> getIndexes() {
            List<IndexSummary.Builder> result = ListIndexesOutputListCopier.copyToBuilder(this.indexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexes(Collection<IndexSummary.BuilderImpl> indexes) {
            this.indexes = ListIndexesOutputListCopier.copyFromBuilder(indexes);
        }

        @Override
        public final Builder indexes(Collection<IndexSummary> indexes) {
            this.indexes = ListIndexesOutputListCopier.copy(indexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(IndexSummary... indexes) {
            indexes(Arrays.asList(indexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(Consumer<IndexSummary.Builder>... indexes) {
            indexes(Stream.of(indexes).map(c -> IndexSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIndexesResponse build() {
            return new ListIndexesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
