/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVectorsRequest extends S3VectorsRequest implements
        ToCopyableBuilder<GetVectorsRequest.Builder, GetVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(GetVectorsRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(GetVectorsRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(GetVectorsRequest::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("keys")
            .getter(getter(GetVectorsRequest::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnData").getter(getter(GetVectorsRequest::returnData)).setter(setter(Builder::returnData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnData").build()).build();

    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnMetadata").getter(getter(GetVectorsRequest::returnMetadata))
            .setter(setter(Builder::returnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            INDEX_NAME_FIELD, INDEX_ARN_FIELD, KEYS_FIELD, RETURN_DATA_FIELD, RETURN_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String indexName;

    private final String indexArn;

    private final List<String> keys;

    private final Boolean returnData;

    private final Boolean returnMetadata;

    private GetVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.keys = builder.keys;
        this.returnData = builder.returnData;
        this.returnMetadata = builder.returnMetadata;
    }

    /**
     * <p>
     * The name of the vector bucket that contains the vector index.
     * </p>
     * 
     * @return The name of the vector bucket that contains the vector index.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The name of the vector index.
     * </p>
     * 
     * @return The name of the vector index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The ARN of the vector index.
     * </p>
     * 
     * @return The ARN of the vector index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the vectors you want to return attributes for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The names of the vectors you want to return attributes for.
     */
    public final List<String> keys() {
        return keys;
    }

    /**
     * <p>
     * Indicates whether to include the vector data in the response. The default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to include the vector data in the response. The default value is <code>false</code>.
     */
    public final Boolean returnData() {
        return returnData;
    }

    /**
     * <p>
     * Indicates whether to include metadata in the response. The default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to include metadata in the response. The default value is <code>false</code>.
     */
    public final Boolean returnMetadata() {
        return returnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnData());
        hashCode = 31 * hashCode + Objects.hashCode(returnMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorsRequest)) {
            return false;
        }
        GetVectorsRequest other = (GetVectorsRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexArn(), other.indexArn()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && Objects.equals(returnData(), other.returnData())
                && Objects.equals(returnMetadata(), other.returnMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVectorsRequest").add("VectorBucketName", vectorBucketName()).add("IndexName", indexName())
                .add("IndexArn", indexArn()).add("Keys", hasKeys() ? keys() : null).add("ReturnData", returnData())
                .add("ReturnMetadata", returnMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "returnData":
            return Optional.ofNullable(clazz.cast(returnData()));
        case "returnMetadata":
            return Optional.ofNullable(clazz.cast(returnMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("keys", KEYS_FIELD);
        map.put("returnData", RETURN_DATA_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVectorsRequest, T> g) {
        return obj -> g.apply((GetVectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetVectorsRequest> {
        /**
         * <p>
         * The name of the vector bucket that contains the vector index.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket that contains the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The name of the vector index.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The ARN of the vector index.
         * </p>
         * 
         * @param indexArn
         *        The ARN of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The names of the vectors you want to return attributes for.
         * </p>
         * 
         * @param keys
         *        The names of the vectors you want to return attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * The names of the vectors you want to return attributes for.
         * </p>
         * 
         * @param keys
         *        The names of the vectors you want to return attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);

        /**
         * <p>
         * Indicates whether to include the vector data in the response. The default value is <code>false</code>.
         * </p>
         * 
         * @param returnData
         *        Indicates whether to include the vector data in the response. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnData(Boolean returnData);

        /**
         * <p>
         * Indicates whether to include metadata in the response. The default value is <code>false</code>.
         * </p>
         * 
         * @param returnMetadata
         *        Indicates whether to include metadata in the response. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnMetadata(Boolean returnMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String indexName;

        private String indexArn;

        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private Boolean returnData;

        private Boolean returnMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorsRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            indexName(model.indexName);
            indexArn(model.indexArn);
            keys(model.keys);
            returnData(model.returnData);
            returnMetadata(model.returnMetadata);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = GetVectorsInputListCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = GetVectorsInputListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        public final Boolean getReturnData() {
            return returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVectorsRequest build() {
            return new GetVectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
