/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIndexRequest extends S3VectorsRequest implements
        ToCopyableBuilder<CreateIndexRequest.Builder, CreateIndexRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(CreateIndexRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> VECTOR_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketArn").getter(getter(CreateIndexRequest::vectorBucketArn))
            .setter(setter(Builder::vectorBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketArn").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(CreateIndexRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(CreateIndexRequest::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<Integer> DIMENSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimension").getter(getter(CreateIndexRequest::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()).build();

    private static final SdkField<String> DISTANCE_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distanceMetric").getter(getter(CreateIndexRequest::distanceMetricAsString))
            .setter(setter(Builder::distanceMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distanceMetric").build()).build();

    private static final SdkField<MetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField
            .<MetadataConfiguration> builder(MarshallingType.SDK_POJO).memberName("metadataConfiguration")
            .getter(getter(CreateIndexRequest::metadataConfiguration)).setter(setter(Builder::metadataConfiguration))
            .constructor(MetadataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            VECTOR_BUCKET_ARN_FIELD, INDEX_NAME_FIELD, DATA_TYPE_FIELD, DIMENSION_FIELD, DISTANCE_METRIC_FIELD,
            METADATA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String vectorBucketArn;

    private final String indexName;

    private final String dataType;

    private final Integer dimension;

    private final String distanceMetric;

    private final MetadataConfiguration metadataConfiguration;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.vectorBucketArn = builder.vectorBucketArn;
        this.indexName = builder.indexName;
        this.dataType = builder.dataType;
        this.dimension = builder.dimension;
        this.distanceMetric = builder.distanceMetric;
        this.metadataConfiguration = builder.metadataConfiguration;
    }

    /**
     * <p>
     * The name of the vector bucket to create the vector index in.
     * </p>
     * 
     * @return The name of the vector bucket to create the vector index in.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
     */
    public final String vectorBucketArn() {
        return vectorBucketArn;
    }

    /**
     * <p>
     * The name of the vector index to create.
     * </p>
     * 
     * @return The name of the vector index to create.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The data type of the vectors to be inserted into the vector index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the vectors to be inserted into the vector index.
     * @see DataType
     */
    public final DataType dataType() {
        return DataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the vectors to be inserted into the vector index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the vectors to be inserted into the vector index.
     * @see DataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The dimensions of the vectors to be inserted into the vector index.
     * </p>
     * 
     * @return The dimensions of the vectors to be inserted into the vector index.
     */
    public final Integer dimension() {
        return dimension;
    }

    /**
     * <p>
     * The distance metric to be used for similarity search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceMetric}
     * will return {@link DistanceMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #distanceMetricAsString}.
     * </p>
     * 
     * @return The distance metric to be used for similarity search.
     * @see DistanceMetric
     */
    public final DistanceMetric distanceMetric() {
        return DistanceMetric.fromValue(distanceMetric);
    }

    /**
     * <p>
     * The distance metric to be used for similarity search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceMetric}
     * will return {@link DistanceMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #distanceMetricAsString}.
     * </p>
     * 
     * @return The distance metric to be used for similarity search.
     * @see DistanceMetric
     */
    public final String distanceMetricAsString() {
        return distanceMetric;
    }

    /**
     * <p>
     * The metadata configuration for the vector index.
     * </p>
     * 
     * @return The metadata configuration for the vector index.
     */
    public final MetadataConfiguration metadataConfiguration() {
        return metadataConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(distanceMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName())
                && Objects.equals(vectorBucketArn(), other.vectorBucketArn()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(dimension(), other.dimension())
                && Objects.equals(distanceMetricAsString(), other.distanceMetricAsString())
                && Objects.equals(metadataConfiguration(), other.metadataConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIndexRequest").add("VectorBucketName", vectorBucketName())
                .add("VectorBucketArn", vectorBucketArn()).add("IndexName", indexName()).add("DataType", dataTypeAsString())
                .add("Dimension", dimension()).add("DistanceMetric", distanceMetricAsString())
                .add("MetadataConfiguration", metadataConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "vectorBucketArn":
            return Optional.ofNullable(clazz.cast(vectorBucketArn()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "distanceMetric":
            return Optional.ofNullable(clazz.cast(distanceMetricAsString()));
        case "metadataConfiguration":
            return Optional.ofNullable(clazz.cast(metadataConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("vectorBucketArn", VECTOR_BUCKET_ARN_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dimension", DIMENSION_FIELD);
        map.put("distanceMetric", DISTANCE_METRIC_FIELD);
        map.put("metadataConfiguration", METADATA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIndexRequest> {
        /**
         * <p>
         * The name of the vector bucket to create the vector index in.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket to create the vector index in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
         * </p>
         * 
         * @param vectorBucketArn
         *        The Amazon Resource Name (ARN) of the vector bucket to create the vector index in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketArn(String vectorBucketArn);

        /**
         * <p>
         * The name of the vector index to create.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The data type of the vectors to be inserted into the vector index.
         * </p>
         * 
         * @param dataType
         *        The data type of the vectors to be inserted into the vector index.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the vectors to be inserted into the vector index.
         * </p>
         * 
         * @param dataType
         *        The data type of the vectors to be inserted into the vector index.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(DataType dataType);

        /**
         * <p>
         * The dimensions of the vectors to be inserted into the vector index.
         * </p>
         * 
         * @param dimension
         *        The dimensions of the vectors to be inserted into the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(Integer dimension);

        /**
         * <p>
         * The distance metric to be used for similarity search.
         * </p>
         * 
         * @param distanceMetric
         *        The distance metric to be used for similarity search.
         * @see DistanceMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceMetric
         */
        Builder distanceMetric(String distanceMetric);

        /**
         * <p>
         * The distance metric to be used for similarity search.
         * </p>
         * 
         * @param distanceMetric
         *        The distance metric to be used for similarity search.
         * @see DistanceMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceMetric
         */
        Builder distanceMetric(DistanceMetric distanceMetric);

        /**
         * <p>
         * The metadata configuration for the vector index.
         * </p>
         * 
         * @param metadataConfiguration
         *        The metadata configuration for the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfiguration(MetadataConfiguration metadataConfiguration);

        /**
         * <p>
         * The metadata configuration for the vector index.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataConfiguration.Builder} avoiding
         * the need to create one manually via {@link MetadataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #metadataConfiguration(MetadataConfiguration)}.
         * 
         * @param metadataConfiguration
         *        a consumer that will call methods on {@link MetadataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfiguration(MetadataConfiguration)
         */
        default Builder metadataConfiguration(Consumer<MetadataConfiguration.Builder> metadataConfiguration) {
            return metadataConfiguration(MetadataConfiguration.builder().applyMutation(metadataConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String vectorBucketArn;

        private String indexName;

        private String dataType;

        private Integer dimension;

        private String distanceMetric;

        private MetadataConfiguration metadataConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            vectorBucketArn(model.vectorBucketArn);
            indexName(model.indexName);
            dataType(model.dataType);
            dimension(model.dimension);
            distanceMetric(model.distanceMetric);
            metadataConfiguration(model.metadataConfiguration);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getVectorBucketArn() {
            return vectorBucketArn;
        }

        public final void setVectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
        }

        @Override
        public final Builder vectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Integer getDimension() {
            return dimension;
        }

        public final void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getDistanceMetric() {
            return distanceMetric;
        }

        public final void setDistanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
        }

        @Override
        public final Builder distanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
            return this;
        }

        @Override
        public final Builder distanceMetric(DistanceMetric distanceMetric) {
            this.distanceMetric(distanceMetric == null ? null : distanceMetric.toString());
            return this;
        }

        public final MetadataConfiguration.Builder getMetadataConfiguration() {
            return metadataConfiguration != null ? metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(MetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(MetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
