/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.s3vectors.auth.scheme.S3VectorsAuthSchemeParams;
import software.amazon.awssdk.services.s3vectors.auth.scheme.internal.DefaultS3VectorsAuthSchemeProvider;
import software.amazon.awssdk.services.s3vectors.auth.scheme.internal.PreferredS3VectorsAuthSchemeProvider;

@SdkPublicApi
public interface S3VectorsAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(S3VectorsAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<S3VectorsAuthSchemeParams.Builder> consumer) {
        S3VectorsAuthSchemeParams.Builder builder = S3VectorsAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static S3VectorsAuthSchemeProvider defaultProvider() {
        return DefaultS3VectorsAuthSchemeProvider.create();
    }

    public static S3VectorsAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredS3VectorsAuthSchemeProvider(S3VectorsAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

